/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.quantity;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.units.indriya.AbstractQuantity;
import tec.units.indriya.ComparableQuantity;
import tec.units.indriya.quantity.NumberQuantity;

final class ByteQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private static final long serialVersionUID = 6325849816534488248L;
    final byte value;

    ByteQuantity(byte value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return super.getUnit().equals(unit) ? (double)this.value : super.getUnit().getConverterTo(unit).convert((double)this.value);
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit, MathContext ctx) {
        return BigDecimal.valueOf(this.doubleValue(unit));
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        Quantity converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value + converted.getValue().byteValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        Quantity converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value - converted.getValue().byteValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return NumberQuantity.of((short)this.value / that.getValue().byteValue(), this.getUnit().divide(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return NumberQuantity.of(this.value / that.byteValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> multiplier) {
        return NumberQuantity.of(this.value * multiplier.getValue().byteValue(), this.getUnit().multiply(multiplier.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number multiplier) {
        return NumberQuantity.of(this.value * multiplier.byteValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> inverse() {
        return NumberQuantity.of(1 / this.value, this.getUnit().inverse());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }
}

