/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.spi.SystemOfUnits;
import tec.uom.se.AbstractUnit;

public abstract class AbstractSystemOfUnits
implements SystemOfUnits {
    protected final Set<Unit<?>> units = new HashSet();
    protected final Map<Class<? extends Quantity>, AbstractUnit> quantityToUnit = new HashMap<Class<? extends Quantity>, AbstractUnit>();
    protected static final double E = Math.E;

    public abstract String getName();

    public Set<Unit<?>> getUnits() {
        return Collections.unmodifiableSet(this.units);
    }

    public Set<? extends Unit<?>> getUnits(Dimension dimension) {
        return this.getUnits().stream().filter(unit -> dimension.equals(unit.getDimension())).collect(Collectors.toSet());
    }

    public <Q extends Quantity<Q>> AbstractUnit<Q> getUnit(Class<Q> quantityType) {
        return this.quantityToUnit.get(quantityType);
    }

    static class Helper {
        Helper() {
        }

        static Set<Unit<?>> getUnitsOfDimension(Set<Unit<?>> units, Dimension dimension) {
            if (dimension != null) {
                return units.stream().filter(u -> dimension.equals(u.getDimension())).collect(Collectors.toSet());
            }
            return null;
        }
    }
}

