/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.format;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import javax.measure.format.UnitFormat;
import tec.uom.se.AbstractUnit;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.format.QuantityFormat;
import tec.uom.se.quantity.Quantities;

class NumberSpaceUnitFormat
extends QuantityFormat {
    private final NumberFormat numberFormat;
    private final UnitFormat unitFormat;
    private static final long serialVersionUID = 1L;

    NumberSpaceUnitFormat(NumberFormat numberFormat, UnitFormat unitFormat) {
        this.numberFormat = numberFormat;
        this.unitFormat = unitFormat;
    }

    @Override
    public Appendable format(Quantity<?> measure, Appendable dest) throws IOException {
        dest.append(this.numberFormat.format(measure.getValue()));
        if (measure.getUnit().equals(AbstractUnit.ONE)) {
            return dest;
        }
        dest.append(' ');
        return this.unitFormat.format(measure.getUnit(), dest);
    }

    @Override
    public ComparableQuantity<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException, ParserException {
        String str = csq.toString();
        Number number = this.numberFormat.parse(str, cursor);
        if (number == null) {
            throw new IllegalArgumentException("Number cannot be parsed");
        }
        Unit unit = this.unitFormat.parse(csq);
        return Quantities.getQuantity(number.longValue(), unit);
    }

    @Override
    public ComparableQuantity<?> parse(CharSequence csq) throws IllegalArgumentException, ParserException {
        return this.parse(csq, new ParsePosition(0));
    }
}

