/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import tec.uom.se.AbstractConverter;
import tec.uom.se.function.PiDivisorConverter;
import tec.uom.se.function.ValueSupplier;

public final class PiMultiplierConverter
extends AbstractConverter
implements ValueSupplier<String> {
    private static final BigDecimal TWO = new BigDecimal("2");
    private static final BigDecimal FOUR = new BigDecimal("4");
    private static final BigDecimal FIVE = new BigDecimal("5");
    private static final BigDecimal TWO_THIRTY_NINE = new BigDecimal("239");

    @Override
    public double convert(double value) {
        return value * Math.PI;
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        int nbrDigits = ctx.getPrecision();
        if (nbrDigits == 0) {
            throw new ArithmeticException("Pi multiplication with unlimited precision");
        }
        BigDecimal pi = Pi.pi(nbrDigits);
        return value.multiply(pi, ctx).scaleByPowerOfTen(1 - nbrDigits);
    }

    @Override
    public AbstractConverter inverse() {
        return new PiDivisorConverter();
    }

    public final String toString() {
        return "(\u03c0)";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PiMultiplierConverter;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    public boolean isLinear() {
        return true;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    static final class Pi {
        private Pi() {
        }

        public static BigDecimal pi(int numDigits) {
            int calcDigits = numDigits + 10;
            return FOUR.multiply(FOUR.multiply(Pi.arccot(FIVE, calcDigits)).subtract(Pi.arccot(TWO_THIRTY_NINE, calcDigits))).setScale(numDigits, RoundingMode.DOWN);
        }

        private static BigDecimal arccot(BigDecimal x, int numDigits) {
            BigDecimal unity = BigDecimal.ONE.setScale(numDigits, RoundingMode.DOWN);
            BigDecimal sum = unity.divide(x, RoundingMode.DOWN);
            BigDecimal xpower = new BigDecimal(sum.toString());
            BigDecimal term = null;
            boolean add = false;
            BigDecimal n = new BigDecimal("3");
            while (term == null || !term.equals(BigDecimal.ZERO)) {
                xpower = xpower.divide(x.pow(2), RoundingMode.DOWN);
                term = xpower.divide(n, RoundingMode.DOWN);
                sum = add ? sum.add(term) : sum.subtract(term);
                add = !add;
                n = n.add(TWO);
            }
            return sum;
        }
    }
}

