/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.quantity.time;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.quantity.time.TimeQuantities;

public class TimeUnitQuantity {
    private TimeUnit timeUnit;
    private Integer value;

    TimeUnitQuantity(TimeUnit timeUnit, Integer value) {
        this.timeUnit = timeUnit;
        this.value = value;
    }

    public static TimeUnitQuantity of(TimeUnit timeUnit, Integer number) {
        return new TimeUnitQuantity(Objects.requireNonNull(timeUnit), Objects.requireNonNull(number));
    }

    public static TimeUnitQuantity of(Quantity<Time> quantity) {
        Quantity seconds = Objects.requireNonNull(quantity).to(TimeQuantities.SECOND);
        return new TimeUnitQuantity(TimeUnit.SECONDS, seconds.getValue().intValue());
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Integer getValue() {
        return this.value;
    }

    public Unit<Time> toUnit() {
        return this.toUnit(this.timeUnit);
    }

    public Quantity<Time> toQuantity() {
        return Quantities.getQuantity(this.value, this.toUnit());
    }

    public TimeUnitQuantity to(TimeUnit timeUnit) {
        Quantity time = this.toQuantity().to(this.toUnit(timeUnit));
        return new TimeUnitQuantity(timeUnit, time.getValue().intValue());
    }

    private Unit<Time> toUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case MICROSECONDS: {
                return TimeQuantities.MICROSECOND;
            }
            case MILLISECONDS: {
                return TimeQuantities.MILLISECOND;
            }
            case NANOSECONDS: {
                return TimeQuantities.NANOSECOND;
            }
            case SECONDS: {
                return TimeQuantities.SECOND;
            }
            case MINUTES: {
                return TimeQuantities.MINUTE;
            }
            case HOURS: {
                return TimeQuantities.HOUR;
            }
            case DAYS: {
                return TimeQuantities.DAY;
            }
        }
        throw new IllegalStateException("In TimeUnitQuantity just supports DAYS, HOURS, MICROSECONDS, MILLISECONDS, MINUTES, NANOSECONDS, SECONDS ");
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timeUnit, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (TimeUnitQuantity.class.isInstance(obj)) {
            TimeUnitQuantity other = (TimeUnitQuantity)TimeUnitQuantity.class.cast(obj);
            return Objects.equals((Object)this.timeUnit, (Object)other.timeUnit) && Objects.equals(this.value, other.value);
        }
        return super.equals(obj);
    }

    public String toString() {
        return "Time unit:" + (Object)((Object)this.timeUnit) + " value: " + this.value;
    }
}

