/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.spi;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.Action;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.DynamicViscosity;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPermittivity;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Information;
import javax.measure.quantity.InformationRate;
import javax.measure.quantity.IonizingRadiation;
import javax.measure.quantity.KinematicViscosity;
import javax.measure.quantity.Length;
import javax.measure.quantity.Luminance;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFieldStrength;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.MagneticPermeability;
import javax.measure.quantity.MagnetomotiveForce;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.quantity.WaveNumber;
import tec.uom.se.AbstractSystemOfUnits;
import tec.uom.se.AbstractUnit;
import tec.uom.se.function.PiMultiplierConverter;
import tec.uom.se.spi.SI;
import tec.uom.se.spi.SIPrefix;
import tec.uom.se.unit.AlternateUnit;
import tec.uom.se.unit.ProductUnit;

public final class UCUM
extends AbstractSystemOfUnits {
    private static final UCUM INSTANCE = new UCUM();
    public static final Unit<Length> METER = UCUM.addUnit(SI.METRE);
    public static final Unit<Time> SECOND = UCUM.addUnit(SI.SECOND);
    public static final Unit<Mass> GRAM = UCUM.addUnit(SI.GRAM);
    public static final Unit<Angle> RADIAN = UCUM.addUnit(SI.RADIAN);
    public static final Unit<Temperature> KELVIN = UCUM.addUnit(SI.KELVIN);
    public static final Unit<ElectricCharge> COULOMB = UCUM.addUnit(SI.COULOMB);
    public static final Unit<LuminousIntensity> CANDELA = UCUM.addUnit(SI.CANDELA);
    public static final Unit<Dimensionless> TRILLIONS = UCUM.addUnit(AbstractUnit.ONE.multiply(1.0E12));
    public static final Unit<Dimensionless> BILLIONS = UCUM.addUnit(AbstractUnit.ONE.multiply(1.0E9));
    public static final Unit<Dimensionless> MILLIONS = UCUM.addUnit(AbstractUnit.ONE.multiply(1000000.0));
    public static final Unit<Dimensionless> THOUSANDS = UCUM.addUnit(AbstractUnit.ONE.multiply(1000.0));
    public static final Unit<Dimensionless> HUNDREDS = UCUM.addUnit(AbstractUnit.ONE.multiply(100.0));
    public static final Unit<Dimensionless> PI = UCUM.addUnit(AbstractUnit.ONE.transform(new PiMultiplierConverter()));
    public static final Unit<Dimensionless> PERCENT = UCUM.addUnit(AbstractUnit.ONE.divide(100.0));
    public static final Unit<Dimensionless> PER_THOUSAND = UCUM.addUnit(AbstractUnit.ONE.divide(1000.0));
    public static final Unit<Dimensionless> PER_MILLION = UCUM.addUnit(AbstractUnit.ONE.divide(1000000.0));
    public static final Unit<Dimensionless> PER_BILLION = UCUM.addUnit(AbstractUnit.ONE.divide(1.0E9));
    public static final Unit<Dimensionless> PER_TRILLION = UCUM.addUnit(AbstractUnit.ONE.divide(1.0E12));
    public static final Unit<AmountOfSubstance> MOLE = UCUM.addUnit(SI.MOLE);
    public static final Unit<SolidAngle> STERADIAN = UCUM.addUnit(SI.STERADIAN);
    public static final Unit<Frequency> HERTZ = UCUM.addUnit(SI.HERTZ);
    public static final Unit<Force> NEWTON = UCUM.addUnit(SI.NEWTON);
    public static final Unit<Pressure> PASCAL = UCUM.addUnit(SI.PASCAL);
    public static final Unit<Energy> JOULE = UCUM.addUnit(SI.JOULE);
    public static final Unit<Power> WATT = UCUM.addUnit(SI.WATT);
    public static final Unit<ElectricCurrent> AMPERE = UCUM.addUnit(SI.AMPERE);
    public static final Unit<MagnetomotiveForce> AMPERE_TURN = UCUM.addUnit(SI.AMPERE_TURN);
    public static final Unit<ElectricPotential> VOLT = UCUM.addUnit(SI.VOLT);
    public static final Unit<ElectricCapacitance> FARAD = UCUM.addUnit(SI.FARAD);
    public static final Unit<ElectricResistance> OHM = UCUM.addUnit(SI.OHM);
    public static final Unit<ElectricConductance> SIEMENS = UCUM.addUnit(SI.SIEMENS);
    public static final Unit<MagneticFlux> WEBER = UCUM.addUnit(SI.WEBER);
    public static final Unit<Temperature> CELSIUS = UCUM.addUnit(SI.CELSIUS);
    public static final Unit<MagneticFluxDensity> TESLA = UCUM.addUnit(SI.TESLA);
    public static final Unit<ElectricInductance> HENRY = UCUM.addUnit(SI.HENRY);
    public static final Unit<LuminousFlux> LUMEN = UCUM.addUnit(SI.LUMEN);
    public static final Unit<Illuminance> LUX = UCUM.addUnit(SI.LUX);
    public static final Unit<Radioactivity> BECQUEREL = UCUM.addUnit(SI.BECQUEREL);
    public static final Unit<RadiationDoseAbsorbed> GRAY = UCUM.addUnit(SI.GRAY);
    public static final Unit<RadiationDoseEffective> SIEVERT = UCUM.addUnit(SI.SIEVERT);
    public static final Unit<Angle> DEGREE = UCUM.addUnit(SI.DEGREE_ANGLE);
    public static final Unit<Angle> GRADE = UCUM.addUnit(SI.DEGREE_ANGLE.multiply(0.9));
    public static final Unit<Angle> GON = GRADE;
    public static final Unit<Angle> MINUTE_ANGLE = UCUM.addUnit(SI.MINUTE_ANGLE);
    public static final Unit<Angle> SECOND_ANGLE = UCUM.addUnit(SI.SECOND_ANGLE);
    public static final Unit<Volume> LITER = UCUM.addUnit(SI.LITRE);
    public static final Unit<Area> ARE = UCUM.addUnit(SI.SQUARE_METRE.multiply(100.0));
    public static final Unit<Time> MINUTE = UCUM.addUnit(SI.MINUTE);
    public static final Unit<Time> HOUR = UCUM.addUnit(SI.HOUR);
    public static final Unit<Time> DAY = UCUM.addUnit(SI.DAY);
    public static final Unit<Time> YEAR_TROPICAL = UCUM.addUnit(SI.DAY.multiply(365.24219));
    public static final Unit<Time> YEAR_JULIAN = UCUM.addUnit(SI.DAY.multiply(365.25));
    public static final Unit<Time> YEAR_GREGORIAN = UCUM.addUnit(SI.DAY.multiply(365.2425));
    public static final Unit<Time> YEAR = UCUM.addUnit(SI.DAY.multiply(365.25));
    public static final Unit<Time> MONTH_SYNODAL = UCUM.addUnit(SI.DAY.multiply(29.53059));
    public static final Unit<Time> MONTH_JULIAN = UCUM.addUnit(YEAR_JULIAN.divide(12.0));
    public static final Unit<Time> MONTH_GREGORIAN = UCUM.addUnit(YEAR_GREGORIAN.divide(12.0));
    public static final Unit<Time> MONTH = UCUM.addUnit(YEAR_JULIAN.divide(12.0));
    public static final Unit<Mass> TONNE = UCUM.addUnit(SI.KILOGRAM.multiply(1000.0));
    public static final Unit<Pressure> BAR = UCUM.addUnit(SI.PASCAL.multiply(100000.0));
    public static final Unit<Mass> ATOMIC_MASS_UNIT = UCUM.addUnit(SI.UNIFIED_ATOMIC_MASS);
    public static final Unit<Energy> ELECTRON_VOLT = UCUM.addUnit(SI.ELECTRON_VOLT);
    public static final Unit<Length> ASTRONOMIC_UNIT = UCUM.addUnit(SI.ASTRONOMICAL_UNIT);
    public static final Unit<Length> PARSEC = UCUM.addUnit(SI.METRE.multiply(3.085678E16));
    public static final Unit<Speed> C = UCUM.addUnit(SI.METRES_PER_SECOND.multiply(2.99792458E8));
    public static final Unit<Action> PLANCK = UCUM.addUnit(SI.JOULE_SECOND.multiply(6.6260755E-24));
    public static final Unit<?> BOLTZMAN = UCUM.addUnit(JOULE.divide(KELVIN).multiply(1.380658E-23));
    public static final Unit<ElectricPermittivity> PERMITTIVITY_OF_VACUUM = UCUM.addUnit(SI.FARADS_PER_METRE.multiply(8.854187817E-12));
    public static final Unit<MagneticPermeability> PERMEABILITY_OF_VACUUM = UCUM.addUnit(new ProductUnit(SI.NEWTONS_PER_SQUARE_AMPERE.multiply(PI.multiply(4.0).divide(1.0E7))), MagneticPermeability.class);
    public static final Unit<ElectricCharge> ELEMENTARY_CHARGE = UCUM.addUnit(SI.COULOMB.transform(SI.ELECTRON_VOLT.getConverterToSI()));
    public static final Unit<Mass> ELECTRON_MASS = UCUM.addUnit(GRAM.multiply(9.1093897E-28));
    public static final Unit<Mass> PROTON_MASS = UCUM.addUnit(GRAM.multiply(1.6726231E-24));
    public static final Unit<?> NEWTON_CONSTANT_OF_GRAVITY = UCUM.addUnit(METER.pow(3).multiply(SI.KILOGRAM.pow(-1)).multiply(SECOND.pow(-2)).multiply(6.67259E-11));
    public static final Unit<Acceleration> ACCELLERATION_OF_FREEFALL = UCUM.addUnit(SI.METRES_PER_SQUARE_SECOND.multiply(9.80665));
    public static final Unit<Pressure> ATMOSPHERE = UCUM.addUnit(SI.PASCAL.multiply(101325.0));
    public static final Unit<Length> LIGHT_YEAR = UCUM.addUnit(new ProductUnit(C.multiply(YEAR_JULIAN)));
    public static final Unit<Force> GRAM_FORCE = UCUM.addUnit(new ProductUnit(GRAM.multiply(ACCELLERATION_OF_FREEFALL)));
    public static final Unit<WaveNumber> KAYSER = UCUM.addUnit(SI.RECIPROCAL_METRE.divide(100.0));
    public static final Unit<Acceleration> GAL = UCUM.addUnit(new ProductUnit(SIPrefix.CENTI(METER).divide(SECOND.pow(2))));
    public static final Unit<Force> DYNE = UCUM.addUnit(new ProductUnit(SI.GRAM.multiply(SIPrefix.CENTI(SI.METRE).divide(SI.SECOND.pow(2)))));
    public static final Unit<Energy> ERG = UCUM.addUnit(new ProductUnit(DYNE.multiply(SIPrefix.CENTI(SI.METRE))));
    public static final Unit<DynamicViscosity> POISE = UCUM.addUnit(new ProductUnit(DYNE.multiply(SECOND).divide(SIPrefix.CENTI(SI.METRE).pow(2))));
    public static final Unit<ElectricCurrent> BIOT = UCUM.addUnit(AMPERE.multiply(10.0));
    public static final Unit<KinematicViscosity> STOKES = UCUM.addUnit(new ProductUnit(SIPrefix.CENTI(SI.METRE).pow(2).divide(SI.SECOND)));
    public static final Unit<MagneticFlux> MAXWELL = UCUM.addUnit(SI.WEBER.divide(1.0E8));
    public static final Unit<MagneticFluxDensity> GAUSS = UCUM.addUnit(SI.TESLA.divide(10000.0));
    public static final Unit<MagneticFieldStrength> OERSTED = UCUM.addUnit(new ProductUnit(SI.AMPERES_PER_METRE.multiply(250.0).divide(PI)));
    public static final Unit<MagnetomotiveForce> GILBERT = UCUM.addUnit(new ProductUnit(OERSTED.multiply(SIPrefix.CENTI(SI.METRE))));
    public static final Unit<Luminance> STILB = UCUM.addUnit(new ProductUnit(CANDELA.divide(SIPrefix.CENTI(METER).pow(2))));
    public static final Unit<Luminance> LAMBERT = UCUM.addUnit(new ProductUnit(STILB.divide(PI)));
    public static final Unit<Illuminance> PHOT = UCUM.addUnit(LUX.divide(10000.0));
    public static final Unit<Radioactivity> CURIE = UCUM.addUnit(SI.BECQUEREL.multiply(3.7E10));
    public static final Unit<IonizingRadiation> ROENTGEN = UCUM.addUnit(SI.COULOMBS_PER_KILOGRAM.multiply(2.58E-4));
    public static final Unit<RadiationDoseAbsorbed> RAD = UCUM.addUnit(new ProductUnit(ERG.divide(SI.GRAM.multiply(100.0))));
    public static final Unit<RadiationDoseEffective> REM = UCUM.addUnit(new ProductUnit(ERG.divide(SI.GRAM.multiply(100.0))));
    public static final Unit<Length> INCH_INTERNATIONAL = UCUM.addUnit(SIPrefix.CENTI(METER).multiply(254.0).divide(100.0));
    public static final Unit<Length> FOOT_INTERNATIONAL = UCUM.addUnit(INCH_INTERNATIONAL.multiply(12.0));
    public static final Unit<Length> YARD_INTERNATIONAL = UCUM.addUnit(FOOT_INTERNATIONAL.multiply(3.0));
    public static final Unit<Length> MILE_INTERNATIONAL = UCUM.addUnit(FOOT_INTERNATIONAL.multiply(5280.0));
    public static final Unit<Length> FATHOM_INTERNATIONAL = UCUM.addUnit(FOOT_INTERNATIONAL.multiply(6.0));
    public static final Unit<Length> NAUTICAL_MILE_INTERNATIONAL = UCUM.addUnit(METER.multiply(1852.0));
    public static final Unit<Speed> KNOT_INTERNATIONAL = UCUM.addUnit(new ProductUnit(NAUTICAL_MILE_INTERNATIONAL.divide(HOUR)));
    public static final Unit<Area> SQUARE_INCH_INTERNATIONAL = UCUM.addUnit(new ProductUnit(INCH_INTERNATIONAL.pow(2)));
    public static final Unit<Area> SQUARE_FOOT_INTERNATIONAL = UCUM.addUnit(new ProductUnit(FOOT_INTERNATIONAL.pow(2)));
    public static final Unit<Area> SQUARE_YARD_INTERNATIONAL = UCUM.addUnit(new ProductUnit(YARD_INTERNATIONAL.pow(2)));
    public static final Unit<Volume> CUBIC_INCH_INTERNATIONAL = UCUM.addUnit(new ProductUnit(INCH_INTERNATIONAL.pow(3)));
    public static final Unit<Volume> CUBIC_FOOT_INTERNATIONAL = UCUM.addUnit(new ProductUnit(FOOT_INTERNATIONAL.pow(3)));
    public static final Unit<Volume> CUBIC_YARD_INTERNATIONAL = UCUM.addUnit(new ProductUnit(YARD_INTERNATIONAL.pow(3)));
    public static final Unit<Volume> BOARD_FOOT_INTERNATIONAL = UCUM.addUnit(CUBIC_INCH_INTERNATIONAL.multiply(144.0));
    public static final Unit<Volume> CORD_INTERNATIONAL = UCUM.addUnit(CUBIC_FOOT_INTERNATIONAL.multiply(128.0));
    public static final Unit<Length> MIL_INTERNATIONAL = UCUM.addUnit(INCH_INTERNATIONAL.divide(1000.0));
    public static final Unit<Area> CIRCULAR_MIL_INTERNATIONAL = UCUM.addUnit(new ProductUnit(MIL_INTERNATIONAL.pow(2).multiply(PI.divide(4.0))));
    public static final Unit<Length> HAND_INTERNATIONAL = UCUM.addUnit(INCH_INTERNATIONAL.multiply(4.0));
    public static final Unit<Length> FOOT_US_SURVEY = UCUM.addUnit(METER.multiply(1200.0).divide(3937.0));
    public static final Unit<Length> YARD_US_SURVEY = UCUM.addUnit(FOOT_US_SURVEY.multiply(3.0));
    public static final Unit<Length> INCH_US_SURVEY = UCUM.addUnit(FOOT_US_SURVEY.divide(12.0));
    public static final Unit<Length> ROD_US_SURVEY = UCUM.addUnit(FOOT_US_SURVEY.multiply(33.0).divide(2.0));
    public static final Unit<Length> CHAIN_US_SURVEY = UCUM.addUnit(ROD_US_SURVEY.multiply(4.0));
    public static final Unit<Length> LINK_US_SURVEY = UCUM.addUnit(CHAIN_US_SURVEY.divide(100.0));
    public static final Unit<Length> RAMDEN_CHAIN_US_SURVEY = UCUM.addUnit(FOOT_US_SURVEY.multiply(100.0));
    public static final Unit<Length> RAMDEN_LINK_US_SURVEY = UCUM.addUnit(CHAIN_US_SURVEY.divide(100.0));
    public static final Unit<Length> FATHOM_US_SURVEY = UCUM.addUnit(FOOT_US_SURVEY.multiply(6.0));
    public static final Unit<Length> FURLONG_US_SURVEY = UCUM.addUnit(ROD_US_SURVEY.multiply(40.0));
    public static final Unit<Length> MILE_US_SURVEY = UCUM.addUnit(FURLONG_US_SURVEY.multiply(8.0));
    public static final Unit<Area> ACRE_US_SURVEY = UCUM.addUnit(new ProductUnit(ROD_US_SURVEY.pow(2)).multiply(160.0));
    public static final Unit<Area> SQUARE_ROD_US_SURVEY = UCUM.addUnit(new ProductUnit(ROD_US_SURVEY.pow(2)));
    public static final Unit<Area> SQUARE_MILE_US_SURVEY = UCUM.addUnit(new ProductUnit(MILE_US_SURVEY.pow(2)));
    public static final Unit<Area> SECTION_US_SURVEY = UCUM.addUnit(new ProductUnit(MILE_US_SURVEY.pow(2)));
    public static final Unit<Area> TOWNSHP_US_SURVEY = UCUM.addUnit(SECTION_US_SURVEY.multiply(36.0));
    public static final Unit<Length> MIL_US_SURVEY = UCUM.addUnit(INCH_US_SURVEY.divide(1000.0));
    public static final Unit<Length> INCH_BRITISH = UCUM.addUnit(SIPrefix.CENTI(METER).multiply(2539998.0).divide(1000000.0));
    public static final Unit<Length> FOOT_BRITISH = UCUM.addUnit(INCH_BRITISH.multiply(12.0));
    public static final Unit<Length> ROD_BRITISH = UCUM.addUnit(FOOT_BRITISH.multiply(33.0).divide(2.0));
    public static final Unit<Length> CHAIN_BRITISH = UCUM.addUnit(ROD_BRITISH.multiply(4.0));
    public static final Unit<Length> LINK_BRITISH = UCUM.addUnit(CHAIN_BRITISH.divide(100.0));
    public static final Unit<Length> FATHOM_BRITISH = UCUM.addUnit(FOOT_BRITISH.multiply(6.0));
    public static final Unit<Length> PACE_BRITISH = UCUM.addUnit(FOOT_BRITISH.multiply(5.0).divide(20.0));
    public static final Unit<Length> YARD_BRITISH = UCUM.addUnit(FOOT_BRITISH.multiply(3.0));
    public static final Unit<Length> MILE_BRITISH = UCUM.addUnit(FOOT_BRITISH.multiply(5280.0));
    public static final Unit<Length> NAUTICAL_MILE_BRITISH = UCUM.addUnit(FOOT_BRITISH.multiply(6080.0));
    public static final Unit<Speed> KNOT_BRITISH = UCUM.addUnit(new ProductUnit(NAUTICAL_MILE_BRITISH.divide(HOUR)));
    public static final Unit<Area> ACRE_BRITISH = UCUM.addUnit(new ProductUnit(YARD_BRITISH.pow(2)).multiply(4840.0));
    public static final Unit<Volume> GALLON_US = UCUM.addUnit(CUBIC_INCH_INTERNATIONAL.multiply(231.0));
    public static final Unit<Volume> BARREL_US = UCUM.addUnit(GALLON_US.multiply(42.0));
    public static final Unit<Volume> QUART_US = UCUM.addUnit(GALLON_US.divide(4.0));
    public static final Unit<Volume> PINT_US = UCUM.addUnit(QUART_US.divide(2.0));
    public static final Unit<Volume> GILL_US = UCUM.addUnit(PINT_US.divide(4.0));
    public static final Unit<Volume> FLUID_OUNCE_US = UCUM.addUnit(GILL_US.divide(4.0));
    public static final Unit<Volume> FLUID_DRAM_US = UCUM.addUnit(FLUID_OUNCE_US.divide(8.0));
    public static final Unit<Volume> MINIM_US = UCUM.addUnit(FLUID_DRAM_US.divide(60.0));
    public static final Unit<Volume> CORD_US = UCUM.addUnit(CUBIC_FOOT_INTERNATIONAL.multiply(128.0));
    public static final Unit<Volume> BUSHEL_US = UCUM.addUnit(CUBIC_INCH_INTERNATIONAL.multiply(215042.0).divide(100.0));
    public static final Unit<Volume> GALLON_WINCHESTER = UCUM.addUnit(BUSHEL_US.divide(8.0));
    public static final Unit<Volume> PECK_US = UCUM.addUnit(BUSHEL_US.divide(4.0));
    public static final Unit<Volume> DRY_QUART_US = UCUM.addUnit(PECK_US.divide(8.0));
    public static final Unit<Volume> DRY_PINT_US = UCUM.addUnit(DRY_QUART_US.divide(2.0));
    public static final Unit<Volume> TABLESPOON_US = UCUM.addUnit(FLUID_OUNCE_US.divide(2.0));
    public static final Unit<Volume> TEASPOON_US = UCUM.addUnit(TABLESPOON_US.divide(3.0));
    public static final Unit<Volume> CUP_US = UCUM.addUnit(TABLESPOON_US.multiply(16.0));
    public static final Unit<Volume> GALLON_BRITISH = UCUM.addUnit(LITER.multiply(454609.0).divide(100000.0));
    public static final Unit<Volume> PECK_BRITISH = UCUM.addUnit(GALLON_BRITISH.multiply(2.0));
    public static final Unit<Volume> BUSHEL_BRITISH = UCUM.addUnit(PECK_BRITISH.multiply(4.0));
    public static final Unit<Volume> QUART_BRITISH = UCUM.addUnit(GALLON_BRITISH.divide(4.0));
    public static final Unit<Volume> PINT_BRITISH = UCUM.addUnit(QUART_BRITISH.divide(2.0));
    public static final Unit<Volume> GILL_BRITISH = UCUM.addUnit(PINT_BRITISH.divide(4.0));
    public static final Unit<Volume> FLUID_OUNCE_BRITISH = UCUM.addUnit(GILL_BRITISH.divide(5.0));
    public static final Unit<Volume> FLUID_DRAM_BRITISH = UCUM.addUnit(FLUID_OUNCE_BRITISH.divide(8.0));
    public static final Unit<Volume> MINIM_BRITISH = UCUM.addUnit(FLUID_DRAM_BRITISH.divide(60.0));
    public static final Unit<Mass> GRAIN = UCUM.addUnit(SIPrefix.MILLI(GRAM).multiply(6479891.0).divide(100000.0));
    public static final Unit<Mass> POUND = UCUM.addUnit(GRAIN.multiply(7000.0));
    public static final Unit<Mass> OUNCE = UCUM.addUnit(POUND.divide(16.0));
    public static final Unit<Mass> DRAM = UCUM.addUnit(OUNCE.divide(16.0));
    public static final Unit<Mass> SHORT_HUNDREDWEIGHT = UCUM.addUnit(POUND.multiply(100.0));
    public static final Unit<Mass> LONG_HUNDREDWEIGHT = UCUM.addUnit(POUND.multiply(112.0));
    public static final Unit<Mass> SHORT_TON = UCUM.addUnit(SHORT_HUNDREDWEIGHT.multiply(20.0));
    public static final Unit<Mass> LONG_TON = UCUM.addUnit(LONG_HUNDREDWEIGHT.multiply(20.0));
    public static final Unit<Mass> STONE = UCUM.addUnit(POUND.multiply(14.0));
    public static final Unit<Force> POUND_FORCE = UCUM.addUnit(POUND.multiply(ACCELLERATION_OF_FREEFALL).asType(Force.class));
    public static final Unit<Mass> PENNYWEIGHT_TROY = UCUM.addUnit(GRAIN.multiply(24.0));
    public static final Unit<Mass> OUNCE_TROY = UCUM.addUnit(PENNYWEIGHT_TROY.multiply(24.0));
    public static final Unit<Mass> POUND_TROY = UCUM.addUnit(OUNCE_TROY.multiply(12.0));
    public static final Unit<Mass> SCRUPLE_APOTHECARY = UCUM.addUnit(GRAIN.multiply(20.0));
    public static final Unit<Mass> DRAM_APOTHECARY = UCUM.addUnit(SCRUPLE_APOTHECARY.multiply(3.0));
    public static final Unit<Mass> OUNCE_APOTHECARY = UCUM.addUnit(DRAM_APOTHECARY.multiply(8.0));
    public static final Unit<Mass> POUND_APOTHECARY = UCUM.addUnit(OUNCE_APOTHECARY.multiply(12.0));
    public static final Unit<Length> LINE = UCUM.addUnit(INCH_INTERNATIONAL.divide(12.0));
    public static final Unit<Length> POINT = UCUM.addUnit(LINE.divide(6.0));
    public static final Unit<Length> PICA = UCUM.addUnit(POINT.multiply(12.0));
    public static final Unit<Length> POINT_PRINTER = UCUM.addUnit(INCH_INTERNATIONAL.multiply(13837.0).divide(1000000.0));
    public static final Unit<Length> PICA_PRINTER = UCUM.addUnit(POINT_PRINTER.multiply(12.0));
    public static final Unit<Length> PIED = UCUM.addUnit(SIPrefix.CENTI(METER).multiply(3248.0).divide(100.0));
    public static final Unit<Length> POUCE = UCUM.addUnit(PIED.divide(12.0));
    public static final Unit<Length> LINGE = UCUM.addUnit(POUCE.divide(12.0));
    public static final Unit<Length> DIDOT = UCUM.addUnit(LINGE.divide(6.0));
    public static final Unit<Length> CICERO = UCUM.addUnit(DIDOT.multiply(12.0));
    public static final Unit<Temperature> FAHRENHEIT = UCUM.addUnit(KELVIN.multiply(5.0).divide(9.0).shift(459.67));
    public static final Unit<Energy> CALORIE_AT_15C = UCUM.addUnit(JOULE.multiply(41858.0).divide(10000.0));
    public static final Unit<Energy> CALORIE_AT_20C = UCUM.addUnit(JOULE.multiply(41819.0).divide(10000.0));
    public static final Unit<Energy> CALORIE_MEAN = UCUM.addUnit(JOULE.multiply(419002.0).divide(100000.0));
    public static final Unit<Energy> CALORIE_INTERNATIONAL_TABLE = UCUM.addUnit(JOULE.multiply(41868.0).divide(10000.0));
    public static final Unit<Energy> CALORIE_THERMOCHEMICAL = UCUM.addUnit(JOULE.multiply(4184.0).divide(1000.0));
    public static final Unit<Energy> CALORIE = UCUM.addUnit(CALORIE_THERMOCHEMICAL);
    public static final Unit<Energy> CALORIE_FOOD = UCUM.addUnit(SIPrefix.KILO(CALORIE_THERMOCHEMICAL));
    public static final Unit<Energy> BTU_AT_39F = UCUM.addUnit(SIPrefix.KILO(JOULE).multiply(105967.0).divide(100000.0));
    public static final Unit<Energy> BTU_AT_59F = UCUM.addUnit(SIPrefix.KILO(JOULE).multiply(105480.0).divide(100000.0));
    public static final Unit<Energy> BTU_AT_60F = UCUM.addUnit(SIPrefix.KILO(JOULE).multiply(105468.0).divide(100000.0));
    public static final Unit<Energy> BTU_MEAN = UCUM.addUnit(SIPrefix.KILO(JOULE).multiply(105587.0).divide(100000.0));
    public static final Unit<Energy> BTU_INTERNATIONAL_TABLE = UCUM.addUnit(SIPrefix.KILO(JOULE).multiply(1.05505585262E11).divide(1.0E11));
    public static final Unit<Energy> BTU_THERMOCHEMICAL = UCUM.addUnit(SIPrefix.KILO(JOULE).multiply(105735.0).divide(100000.0));
    public static final Unit<Energy> BTU = UCUM.addUnit(BTU_THERMOCHEMICAL);
    public static final Unit<Power> HORSEPOWER = UCUM.addUnit(new ProductUnit(FOOT_INTERNATIONAL.multiply(POUND_FORCE).divide(SECOND)));
    private static final Unit<? extends Quantity<?>> TMP_MHO = SIEMENS.alternate("mho");
    public static final Unit<Volume> STERE = UCUM.addUnit(new ProductUnit(METER.pow(3)));
    public static final Unit<Length> ANGSTROM = UCUM.addUnit(SIPrefix.NANO(METER).divide(10.0));
    public static final Unit<Area> BARN = UCUM.addUnit(new ProductUnit(SIPrefix.FEMTO(METER).pow(2)).multiply(100.0));
    public static final Unit<Pressure> ATMOSPHERE_TECHNICAL = UCUM.addUnit(new ProductUnit(SIPrefix.KILO(GRAM_FORCE).divide(SIPrefix.CENTI(METER).pow(2))));
    public static final Unit<ElectricConductance> MHO = UCUM.addUnit(new AlternateUnit(TMP_MHO, TMP_MHO.getSymbol()));
    public static final Unit<Pressure> POUND_PER_SQUARE_INCH = UCUM.addUnit(new ProductUnit(POUND_FORCE.divide(INCH_INTERNATIONAL.pow(2))));
    public static final Unit<Angle> CIRCLE = UCUM.addUnit(new ProductUnit(PI.multiply(RADIAN.multiply(2.0))));
    public static final Unit<SolidAngle> SPHERE = UCUM.addUnit(new ProductUnit(PI.multiply(STERADIAN.multiply(4.0))));
    public static final Unit<Mass> CARAT_METRIC = UCUM.addUnit(GRAM.divide(5.0));
    public static final Unit<Dimensionless> CARAT_GOLD = UCUM.addUnit(AbstractUnit.ONE.divide(24.0));
    public static final Unit<Information> BIT = UCUM.addUnit(SI.BIT);
    public static final Unit<Information> BYTE = UCUM.addUnit(SI.BIT.multiply(8.0));
    public static final Unit<InformationRate> BAUD = UCUM.addUnit(SI.BITS_PER_SECOND);
    public static final Unit<Frequency> FRAMES_PER_SECOND = UCUM.addUnit(AbstractUnit.ONE.divide(SECOND)).asType(Frequency.class);

    private UCUM() {
    }

    public static UCUM getInstance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "UCUM";
    }

    private static <U extends Unit<Q>, Q extends Quantity<Q>> U addUnit(U unit) {
        UCUM.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        UCUM.INSTANCE.units.add(unit);
        UCUM.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }
}

