/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.spi.internal;

import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.DynamicViscosity;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Information;
import javax.measure.quantity.IonizingRadiation;
import javax.measure.quantity.KinematicViscosity;
import javax.measure.quantity.Length;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import tec.uom.se.AbstractSystemOfUnits;
import tec.uom.se.AbstractUnit;
import tec.uom.se.function.LogConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.spi.SI;
import tec.uom.se.spi.SIPrefix;

public final class NonSI
extends AbstractSystemOfUnits {
    private static final int STANDARD_GRAVITY_DIVIDEND = 980665;
    private static final int STANDARD_GRAVITY_DIVISOR = 100000;
    public static final int AVOIRDUPOIS_POUND_DIVIDEND = 45359237;
    public static final int AVOIRDUPOIS_POUND_DIVISOR = 100000000;
    private static final double AVOGADRO_CONSTANT = 6.02214199E23;
    private static final double ELEMENTARY_CHARGE = 1.602176462E-19;
    private static final NonSI INSTANCE = new NonSI();
    static final Unit<Dimensionless> PI = NonSI.addUnit(AbstractUnit.ONE.multiply(Math.PI));
    static final Unit<Dimensionless> PERCENT = NonSI.addUnit(AbstractUnit.ONE.divide(100.0));
    static final Unit<Dimensionless> DECIBEL = NonSI.addUnit(AbstractUnit.ONE.transform(new LogConverter(10.0).inverse().concatenate(RationalConverter.of(1.0, 10.0))));
    static final Unit<AmountOfSubstance> ATOM = NonSI.addUnit(SI.MOLE.divide(6.02214199E23));
    static final Unit<Length> FOOT = NonSI.addUnit(SI.METRE.multiply(3048.0).divide(10000.0));
    static final Unit<Length> INCH = NonSI.addUnit(FOOT.divide(12.0));
    static final Unit<Length> ANGSTROM = NonSI.addUnit(SI.METRE.divide(1.0E10));
    static final Unit<Length> ASTRONOMICAL_UNIT = NonSI.addUnit(SI.METRE.multiply(1.49597870691E11));
    static final Unit<Length> LIGHT_YEAR = NonSI.addUnit(SI.METRE.multiply(9.460528405E15));
    static final Unit<Length> PARSEC = NonSI.addUnit(SI.METRE.multiply(3.085677E16));
    static final Unit<Length> POINT = NonSI.addUnit(INCH.multiply(13837.0).divide(1000000.0));
    static final Unit<Length> PIXEL = NonSI.addUnit(INCH.divide(72.0));
    static final Unit<Length> COMPUTER_POINT = PIXEL;
    static final Unit<Time> MINUTE = NonSI.addUnit(SI.SECOND.multiply(60.0));
    static final Unit<Time> HOUR = NonSI.addUnit(MINUTE.multiply(60.0));
    static final Unit<Time> DAY = NonSI.addUnit(HOUR.multiply(24.0));
    static final Unit<Time> DAY_SIDEREAL = NonSI.addUnit(SI.SECOND.multiply(86164.09));
    static final Unit<Time> WEEK = NonSI.addUnit(DAY.multiply(7.0));
    static final Unit<Time> YEAR_CALENDAR = NonSI.addUnit(DAY.multiply(365.0));
    static final Unit<Time> YEAR_SIDEREAL = NonSI.addUnit(SI.SECOND.multiply(3.155814954E7));
    static final Unit<Time> YEAR_JULIEN = NonSI.addUnit(SI.SECOND.multiply(3.15576E7));
    static final Unit<Mass> ATOMIC_MASS = NonSI.addUnit(SI.KILOGRAM.multiply(1.6605387280149467E-27));
    static final Unit<Mass> ELECTRON_MASS = NonSI.addUnit(SI.KILOGRAM.multiply(9.10938188E-31));
    static final Unit<Mass> POUND = NonSI.addUnit(SI.KILOGRAM.multiply(4.5359237E7).divide(1.0E8));
    static final Unit<ElectricCharge> E = NonSI.addUnit(SI.COULOMB.multiply(1.602176462E-19));
    static final Unit<ElectricCharge> FARADAY = NonSI.addUnit(SI.COULOMB.multiply(96485.3414719984));
    static final Unit<ElectricCharge> FRANKLIN = NonSI.addUnit(SI.COULOMB.multiply(3.3356E-10));
    static final Unit<Temperature> RANKINE = NonSI.addUnit(SI.KELVIN.multiply(5.0).divide(9.0));
    static final Unit<Speed> C = NonSI.addUnit(SI.METRES_PER_SECOND.multiply(2.99792458E8));
    static final Unit<Acceleration> G = NonSI.addUnit(SI.METRES_PER_SQUARE_SECOND.multiply(980665.0).divide(100000.0));
    static final Unit<Area> ARE = NonSI.addUnit(SI.SQUARE_METRE.multiply(100.0));
    static final Unit<Information> BYTE = NonSI.addUnit(SI.BIT.multiply(8.0));
    static final Unit<Information> OCTET = BYTE;
    static final Unit<Energy> ERG = NonSI.addUnit(SI.JOULE.divide(1.0E7));
    static final Unit<Energy> ELECTRON_VOLT = NonSI.addUnit(SI.JOULE.multiply(1.602176462E-19));
    static final Unit<Illuminance> LAMBERT = NonSI.addUnit(SI.LUX.multiply(10000.0));
    static final Unit<MagneticFlux> MAXWELL = NonSI.addUnit(SI.WEBER.divide(1.0E8));
    static final Unit<MagneticFluxDensity> GAUSS = NonSI.addUnit(SI.TESLA.divide(10000.0));
    static final Unit<Force> DYNE = NonSI.addUnit(SI.NEWTON.divide(100000.0));
    static final Unit<Force> KILOGRAM_FORCE = NonSI.addUnit(SI.NEWTON.multiply(980665.0).divide(100000.0));
    static final Unit<Force> POUND_FORCE = NonSI.addUnit(SI.NEWTON.multiply(4.4482216152605E13).divide(1.0E13));
    static final Unit<Power> HORSEPOWER = NonSI.addUnit(SI.WATT.multiply(735.499));
    static final Unit<Pressure> ATMOSPHERE = NonSI.addUnit(SI.PASCAL.multiply(101325.0));
    static final Unit<Pressure> BAR = NonSI.addUnit(SI.PASCAL.multiply(100000.0));
    static final Unit<RadiationDoseAbsorbed> RAD = NonSI.addUnit(SI.GRAY.divide(100.0));
    static final Unit<RadiationDoseEffective> REM = NonSI.addUnit(SI.SIEVERT.divide(100.0));
    static final Unit<Radioactivity> CURIE = NonSI.addUnit(SI.BECQUEREL.multiply(3.7E10));
    static final Unit<Radioactivity> RUTHERFORD = NonSI.addUnit(SI.BECQUEREL.multiply(1000000.0));
    static final Unit<DynamicViscosity> POISE = NonSI.addUnit(SI.GRAM.divide(SIPrefix.CENTI(SI.METRE).multiply(SI.SECOND))).asType(DynamicViscosity.class);
    static final Unit<KinematicViscosity> STOKE = NonSI.addUnit(SIPrefix.CENTI(SI.METRE).pow(2).divide(SI.SECOND)).asType(KinematicViscosity.class);
    static final Unit<Frequency> FRAMES_PER_SECOND = NonSI.addUnit(AbstractUnit.ONE.divide((AbstractUnit<?>)SI.SECOND)).asType(Frequency.class);
    public static final Unit<IonizingRadiation> ROENTGEN = NonSI.addUnit(SI.COULOMB.divide((AbstractUnit<?>)SI.KILOGRAM).multiply(2.58E-4));

    private NonSI() {
    }

    static NonSI getInstance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        NonSI.INSTANCE.units.add(unit);
        return unit;
    }
}

