/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.format;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParsePosition;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.format.LocalUnitFormat;
import tec.uom.se.format.QuantityFormat;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.Units;

class DefaultQuantityFormat
extends QuantityFormat {
    private static final long serialVersionUID = 2758248665095734058L;

    DefaultQuantityFormat() {
    }

    public Appendable format(Quantity measure, Appendable dest) throws IOException {
        Unit unit = measure.getUnit();
        dest.append(measure.getValue().toString());
        if (measure.getUnit().equals(Units.ONE)) {
            return dest;
        }
        dest.append(' ');
        return LocalUnitFormat.getInstance().format(unit, dest);
    }

    @Override
    public ComparableQuantity<?> parse(CharSequence csq, ParsePosition cursor) throws ParserException {
        int endDecimal;
        int startDecimal;
        for (startDecimal = cursor.getIndex(); startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal)); ++startDecimal) {
        }
        for (endDecimal = startDecimal + 1; endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal)); ++endDecimal) {
        }
        BigDecimal decimal = new BigDecimal(csq.subSequence(startDecimal, endDecimal).toString());
        cursor.setIndex(endDecimal + 1);
        Unit<?> unit = LocalUnitFormat.getInstance().parse(csq, cursor);
        return Quantities.getQuantity(decimal, unit);
    }

    @Override
    public ComparableQuantity<?> parse(CharSequence csq) throws ParserException {
        return this.parse(csq, new ParsePosition(0));
    }
}

