/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.function;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import tec.uom.se.AbstractConverter;
import tec.uom.se.function.ExpConverter;
import tec.uom.se.function.ValueSupplier;

public final class LogConverter
extends AbstractConverter
implements ValueSupplier<String>,
Serializable {
    private static final long serialVersionUID = -7584688290961460870L;
    private final double base;
    private final double logOfBase;

    public LogConverter(double base) {
        this.base = base;
        this.logOfBase = Math.log(base);
    }

    public double getBase() {
        return this.base;
    }

    @Override
    public AbstractConverter inverse() {
        return new ExpConverter(this.base);
    }

    public final String toString() {
        if (this.base == Math.E) {
            return "ln";
        }
        return "Log(" + this.base + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LogConverter) {
            LogConverter that = (LogConverter)obj;
            return Objects.equals(this.base, that.base);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base);
    }

    @Override
    public double convert(double amount) {
        return Math.log(amount) / this.logOfBase;
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return BigDecimal.valueOf(this.convert(value.doubleValue()));
    }

    public boolean isLinear() {
        return false;
    }

    @Override
    public String getValue() {
        return this.toString();
    }
}

