/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.internal.format.l10n;

class NumberFormat2 {
    public static final String COMMA = ",";
    public static final String PERIOD = ".";
    public static final char DASH = '-';
    public static final char LEFT_PAREN = '(';
    public static final char RIGHT_PAREN = ')';
    private static final String THOUSAND = "k";
    private static final String MILLION = "m";
    private static final String BILLION = "b";
    public static final int CUR_POS_LEFT_OUTSIDE = 0;
    public static final int CUR_POS_LEFT_INSIDE = 1;
    public static final int CUR_POS_RIGHT_INSIDE = 2;
    public static final int CUR_POS_RIGHT_OUTSIDE = 3;
    public static final int NEG_LEFT_DASH = 0;
    public static final int NEG_RIGHT_DASH = 1;
    public static final int NEG_PARENTHESIS = 2;
    public static final int ARBITRARY_PRECISION = -1;
    private String inputDecimalSeparator = ".";
    private boolean showGrouping = true;
    private String groupingSeparator = ",";
    private String decimalSeparator = ".";
    private boolean showCurrencySymbol = false;
    private String currencySymbol = "$";
    private int currencySymbolPosition = 0;
    private int negativeFormat = 0;
    private boolean isNegativeRed = false;
    private int decimalPrecision = 0;
    private boolean useFixedPrecision = false;
    private boolean truncate = false;
    private boolean isPercentage = false;

    private NumberFormat2() {
    }

    public static NumberFormat2 getInstance() {
        NumberFormat2 nf = new NumberFormat2();
        return nf;
    }

    public static NumberFormat2 getCurrencyInstance() {
        return NumberFormat2.getCurrencyInstance("$", true);
    }

    public static NumberFormat2 getCurrencyInstance(String curSymbol) {
        return NumberFormat2.getCurrencyInstance(curSymbol, true);
    }

    public static NumberFormat2 getCurrencyInstance(String curSymbol, boolean useCommas) {
        NumberFormat2 nf = new NumberFormat2();
        nf.isCurrency(true);
        nf.setCurrencySymbol(curSymbol);
        if (!useCommas) {
            nf.setDecimalSeparator(COMMA);
            nf.setGroupingSeparator(PERIOD);
        }
        nf.setFixedPrecision(2);
        return nf;
    }

    public static NumberFormat2 getIntegerInstance() {
        NumberFormat2 nf = new NumberFormat2();
        nf.setShowGrouping(false);
        nf.setFixedPrecision(0);
        return nf;
    }

    public static NumberFormat2 getPercentInstance() {
        NumberFormat2 nf = new NumberFormat2();
        nf.isPercentage(true);
        nf.setFixedPrecision(2);
        nf.setShowGrouping(false);
        return nf;
    }

    public String format(String num) {
        return this.toFormatted(this.parse(num));
    }

    public double parse(String num) {
        return NumberFormat2.asNumber(num, this.inputDecimalSeparator);
    }

    public static double parseDouble(String num, String decimalChar) {
        return NumberFormat2.asNumber(num, decimalChar);
    }

    public static double parseDouble(String num) {
        return NumberFormat2.parseDouble(num, PERIOD);
    }

    public void setInputDecimalSeparator(String val) {
        this.inputDecimalSeparator = val == null ? PERIOD : val;
    }

    public void setNegativeFormat(int format) {
        this.negativeFormat = format;
    }

    public void setNegativeRed(boolean isRed) {
        this.isNegativeRed = isRed;
    }

    public void setShowGrouping(boolean show) {
        this.showGrouping = show;
    }

    public void setDecimalSeparator(String separator) {
        this.decimalSeparator = separator;
    }

    public void setGroupingSeparator(String separator) {
        this.groupingSeparator = separator;
    }

    public void isCurrency(boolean isC) {
        this.showCurrencySymbol = isC;
    }

    public void setCurrencySymbol(String symbol) {
        this.currencySymbol = symbol;
    }

    public void setCurrencyPosition(int cp) {
        this.currencySymbolPosition = cp;
    }

    public void isPercentage(boolean pct) {
        this.isPercentage = pct;
    }

    public void setFixedPrecision(int places) {
        this.useFixedPrecision = places != -1;
        this.decimalPrecision = places < 0 ? 0 : places;
    }

    public void setTruncate(boolean trunc) {
        this.truncate = trunc;
    }

    private String addSeparators(String preSep) {
        int l;
        String nStr = preSep;
        int dpos = nStr.indexOf(PERIOD);
        String nStrEnd = "";
        if (dpos != -1) {
            nStrEnd = this.decimalSeparator + nStr.substring(dpos + 1, nStr.length());
            nStr = nStr.substring(0, dpos);
        }
        for (int i = l = nStr.length(); i > 0; --i) {
            nStrEnd = nStr.charAt(i - 1) + nStrEnd;
            if (i == 1 || (l - i + 1) % 3 != 0) continue;
            nStrEnd = this.groupingSeparator + nStrEnd;
        }
        return nStrEnd;
    }

    protected String toFormatted(double num) {
        if (this.isPercentage) {
            num *= 100.0;
        }
        String nStr = this.useFixedPrecision ? NumberFormat2.toFixed(Math.abs(this.getRounded(num)), this.decimalPrecision) : Double.toString(num);
        nStr = this.showGrouping ? this.addSeparators(nStr) : nStr.replaceAll("\\.", this.decimalSeparator);
        String c0 = "";
        String n0 = "";
        String c1 = "";
        String n1 = "";
        String n2 = "";
        String c2 = "";
        String n3 = "";
        String c3 = "";
        String negSignL = "" + (this.negativeFormat == 2 ? (char)'(' : '-');
        String negSignR = "" + (this.negativeFormat == 2 ? (char)')' : '-');
        if (this.currencySymbolPosition == 0) {
            if (num < 0.0) {
                if (this.negativeFormat == 0 || this.negativeFormat == 2) {
                    n1 = negSignL;
                }
                if (this.negativeFormat == 1 || this.negativeFormat == 2) {
                    n2 = negSignR;
                }
            }
            if (this.showCurrencySymbol) {
                c0 = this.currencySymbol;
            }
        } else if (this.currencySymbolPosition == 1) {
            if (num < 0.0) {
                if (this.negativeFormat == 0 || this.negativeFormat == 2) {
                    n0 = negSignL;
                }
                if (this.negativeFormat == 1 || this.negativeFormat == 2) {
                    n3 = negSignR;
                }
            }
            if (this.showCurrencySymbol) {
                c1 = this.currencySymbol;
            }
        } else if (this.currencySymbolPosition == 2) {
            if (num < 0.0) {
                if (this.negativeFormat == 0 || this.negativeFormat == 2) {
                    n0 = negSignL;
                }
                if (this.negativeFormat == 1 || this.negativeFormat == 2) {
                    n3 = negSignR;
                }
            }
            if (this.showCurrencySymbol) {
                c2 = this.currencySymbol;
            }
        } else if (this.currencySymbolPosition == 3) {
            if (num < 0.0) {
                if (this.negativeFormat == 0 || this.negativeFormat == 2) {
                    n1 = negSignL;
                }
                if (this.negativeFormat == 1 || this.negativeFormat == 2) {
                    n2 = negSignR;
                }
            }
            if (this.showCurrencySymbol) {
                c3 = this.currencySymbol;
            }
        }
        nStr = c0 + n0 + c1 + n1 + nStr + n2 + c2 + n3 + c3 + (this.isPercentage ? "%" : "");
        if (this.isNegativeRed && num < 0.0) {
            nStr = "<font color='red'>" + nStr + "</font>";
        }
        return nStr;
    }

    private double getRounded(double val) {
        double exp = Math.pow(10.0, this.decimalPrecision);
        double rounded = val * exp;
        rounded = this.truncate ? (rounded >= 0.0 ? Math.floor(rounded) : Math.ceil(rounded)) : (double)Math.round(rounded);
        return rounded / exp;
    }

    private static native String toFixed(double var0, int var2);

    private static double asNumber(String val, String inputDecimalValue) {
        Double parsed;
        String newVal = val;
        boolean isPercentage = false;
        if (newVal.indexOf(37) != -1) {
            newVal = newVal.replaceAll("\\%", "");
            isPercentage = true;
        }
        newVal = newVal.toLowerCase().replaceAll(BILLION, "000000000");
        newVal = newVal.replaceAll(MILLION, "000000");
        newVal = newVal.replaceAll(THOUSAND, "000");
        String re = "[^\\" + inputDecimalValue + "\\d\\-\\+\\(\\)eE]";
        int index = (newVal = newVal.replaceAll(re, "")).indexOf(inputDecimalValue);
        if (index != -1) {
            newVal = newVal.substring(0, index) + PERIOD + newVal.substring(index + inputDecimalValue.length()).replaceAll("\\" + inputDecimalValue, "");
        }
        if (newVal.charAt(newVal.length() - 1) == '-') {
            newVal = newVal.substring(0, newVal.length() - 1);
            newVal = '-' + newVal;
        } else if (newVal.charAt(0) == '(' && newVal.charAt(newVal.length() - 1) == ')') {
            newVal = newVal.substring(1, newVal.length() - 1);
            newVal = '-' + newVal;
        }
        try {
            parsed = new Double(newVal);
            if (parsed.isInfinite() || parsed.isNaN()) {
                parsed = 0.0;
            }
        }
        catch (NumberFormatException e) {
            parsed = 0.0;
        }
        return isPercentage ? parsed / 100.0 : parsed;
    }
}

