/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.function;

import java.math.BigDecimal;
import java.math.MathContext;
import tec.uom.lib.common.function.ValueSupplier;
import tec.uom.se.AbstractConverter;
import tec.uom.se.function.PiMultiplierConverter;

final class PiDivisorConverter
extends AbstractConverter
implements ValueSupplier<String> {
    private static final long serialVersionUID = 5052794216568914141L;

    @Override
    public double convert(double value) {
        return value / Math.PI;
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        int nbrDigits = ctx.getPrecision();
        if (nbrDigits == 0) {
            throw new ArithmeticException("Pi multiplication with unlimited precision");
        }
        BigDecimal pi = PiMultiplierConverter.Pi.pi(nbrDigits);
        return value.divide(pi, ctx);
    }

    @Override
    public AbstractConverter inverse() {
        return new PiMultiplierConverter();
    }

    public final String toString() {
        return "(1/\u03c0)";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PiDivisorConverter;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    public boolean isLinear() {
        return true;
    }

    public String getValue() {
        return this.toString();
    }
}

