/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.quantity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.uom.se.AbstractQuantity;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.DecimalQuantity;
import tec.uom.se.quantity.DoubleQuantity;
import tec.uom.se.quantity.NumberUtils;

public class NumberQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q>
implements Serializable {
    private static final long serialVersionUID = 7312161895652321241L;
    private final Number value;
    private final boolean isBig;

    protected NumberQuantity(Number number, Unit<Q> unit) {
        super(unit);
        this.value = number;
        this.isBig = number instanceof BigDecimal || number instanceof BigInteger;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        Unit myUnit = this.getUnit();
        UnitConverter converter = myUnit.getConverterTo(unit);
        return converter.convert(this.getValue().doubleValue());
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    @Override
    public boolean isBig() {
        return this.isBig;
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        return this.toDecimalQuantity().add((Quantity)that);
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return this.toDecimalQuantity().multiply((Quantity)that);
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return this.toDecimalQuantity().multiply(that);
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return this.toDecimalQuantity().divide((Quantity)that);
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return this.toDecimalQuantity().divide(that);
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return new NumberQuantity<Q>(this.getValue() instanceof BigDecimal ? BigDecimal.ONE.divide((BigDecimal)this.getValue()) : Double.valueOf(1.0 / this.getValue().doubleValue()), this.getUnit().inverse());
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit, MathContext ctx) throws ArithmeticException {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        if (this.value instanceof BigInteger) {
            return new BigDecimal((BigInteger)this.value);
        }
        return BigDecimal.valueOf(this.value.doubleValue());
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        return this.toDecimalQuantity().subtract((Quantity)that);
    }

    private DecimalQuantity<Q> toDecimalQuantity() {
        return new DecimalQuantity(BigDecimal.valueOf(this.value.doubleValue()), this.getUnit());
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(double doubleValue, Unit<Q> unit) {
        return new DoubleQuantity<Q>(doubleValue, unit);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractQuantity) {
            AbstractQuantity that = (AbstractQuantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && NumberUtils.hasEquality(this.value, that.getValue());
        }
        return false;
    }
}

