/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.quantity;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

final class NumberUtils {
    NumberUtils() {
    }

    static BigDecimal toBigDecimal(Number value) {
        if (BigDecimal.class.isInstance(value)) {
            return (BigDecimal)BigDecimal.class.cast(value);
        }
        if (BigInteger.class.isInstance(value)) {
            return new BigDecimal((BigInteger)BigInteger.class.cast(value));
        }
        return BigDecimal.valueOf(value.doubleValue());
    }

    static boolean hasEquality(Number valueA, Number valueB) {
        Objects.requireNonNull(valueA);
        Objects.requireNonNull(valueB);
        if (valueA instanceof Double) {
            return valueA.doubleValue() == valueB.doubleValue();
        }
        if (valueA instanceof Float) {
            return valueA.floatValue() == valueB.floatValue();
        }
        if (valueA instanceof Integer) {
            return valueA.intValue() == valueB.intValue();
        }
        if (valueA instanceof Long) {
            return valueA.longValue() == valueB.longValue();
        }
        if (valueA instanceof Short) {
            return valueA.shortValue() == valueB.shortValue();
        }
        if (valueA instanceof Byte) {
            return valueA.byteValue() == valueB.byteValue();
        }
        return NumberUtils.toBigDecimal(valueA).compareTo(NumberUtils.toBigDecimal(valueB)) == 0;
    }
}

