/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external;

import jakarta.annotation.PostConstruct;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import tech.ailef.snapadmin.external.SnapAdminProperties;
import tech.ailef.snapadmin.external.annotations.Disable;
import tech.ailef.snapadmin.external.annotations.DisplayFormat;
import tech.ailef.snapadmin.external.dbmapping.CustomJpaRepository;
import tech.ailef.snapadmin.external.dbmapping.DbObjectSchema;
import tech.ailef.snapadmin.external.dbmapping.fields.DbField;
import tech.ailef.snapadmin.external.dbmapping.fields.DbFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.EnumFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.StringFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.TextFieldType;
import tech.ailef.snapadmin.external.dto.MappingError;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;
import tech.ailef.snapadmin.external.exceptions.SnapAdminNotFoundException;
import tech.ailef.snapadmin.external.exceptions.UnsupportedFieldTypeException;
import tech.ailef.snapadmin.external.misc.Utils;

@Component
public class SnapAdmin {
    private static final Logger logger = LoggerFactory.getLogger((String)SnapAdmin.class.getName());
    private EntityManager entityManager;
    private List<DbObjectSchema> schemas = new ArrayList<DbObjectSchema>();
    private List<String> modelsPackage;
    private SnapAdminProperties properties;
    private boolean authenticated;
    private static final String VERSION = "0.2.0";

    public SnapAdmin(@Autowired EntityManager entityManager, @Autowired SnapAdminProperties properties) {
        this.modelsPackage = Arrays.stream(properties.getModelsPackage().split(",")).map(String::trim).toList();
        this.entityManager = entityManager;
        this.properties = properties;
    }

    @PostConstruct
    private void init() {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        logger.debug("Initializing SnapAdmin...");
        for (String currentPackage : this.modelsPackage) {
            logger.debug("Scanning package " + currentPackage);
            Set beanDefs = provider.findCandidateComponents(currentPackage);
            logger.debug("Found " + beanDefs.size() + " candidate @Entity classes");
            for (BeanDefinition bd : beanDefs) {
                DbObjectSchema schema = this.processBeanDefinition(bd);
                if (schema == null) continue;
                this.schemas.add(schema);
            }
            logger.info("Scanned package '" + currentPackage + "'. Loaded " + beanDefs.size() + " schemas.");
        }
        boolean hasErrors = this.schemas.stream().flatMap(s -> s.getErrors().stream()).count() > 0L;
        logger.info("SnapAdmin initialized. Loaded " + this.schemas.size() + " schemas from " + this.modelsPackage.size() + " packages" + (hasErrors ? " (with errors)" : ""));
        logger.info("SnapAdmin web interface at: http://YOUR_HOST:YOUR_PORT/" + this.properties.getBaseUrl());
    }

    public String getVersion() {
        return VERSION;
    }

    public List<DbObjectSchema> getSchemas() {
        return Collections.unmodifiableList(this.schemas);
    }

    public DbObjectSchema findSchemaByClassName(String className) {
        return this.schemas.stream().filter(s -> s.getClassName().equals(className)).findFirst().orElseThrow(() -> new SnapAdminNotFoundException("Schema " + className + " not found."));
    }

    public DbObjectSchema findSchemaByTableName(String tableName) {
        return this.schemas.stream().filter(s -> s.getTableName().equals(tableName)).findFirst().orElseThrow(() -> new SnapAdminException("Schema " + tableName + " not found."));
    }

    public DbObjectSchema findSchemaByClass(Class<?> klass) {
        return this.findSchemaByClassName(klass.getName());
    }

    public boolean isManagedClass(Class<?> klass) {
        Optional<DbObjectSchema> hasSchema = this.schemas.stream().filter(s -> s.getClassName().equals(klass.getName())).findFirst();
        return hasSchema.isPresent();
    }

    private DbObjectSchema processBeanDefinition(BeanDefinition bd) {
        String fullClassName = bd.getBeanClassName();
        try {
            Field[] fields;
            Class<?> klass = Class.forName(fullClassName);
            Disable disabled = klass.getAnnotation(Disable.class);
            if (disabled != null) {
                return null;
            }
            DbObjectSchema schema = new DbObjectSchema(klass, this);
            CustomJpaRepository simpleJpaRepository = new CustomJpaRepository(schema, this.entityManager);
            schema.setJpaRepository(simpleJpaRepository);
            logger.debug("Processing class: " + klass + " - Table: " + schema.getTableName());
            for (Field f : fields = klass.getDeclaredFields()) {
                try {
                    DbField field = this.mapField(f, schema);
                    field.setSchema(schema);
                    schema.addField(field);
                }
                catch (UnsupportedFieldTypeException e) {
                    logger.warn("The class " + klass.getSimpleName() + " contains the field `" + f.getName() + "` of type `" + f.getType().getSimpleName() + "`, which is not supported");
                    schema.addError(new MappingError("The class contains the field `" + f.getName() + "` of type `" + f.getType().getSimpleName() + "`, which is not supported"));
                }
            }
            logger.debug("Processed " + klass + ", extracted " + schema.getSortedFields().size() + " fields");
            return schema;
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private String determineFieldName(Field f) {
        Column col;
        Column[] columnAnnotations = (Column[])f.getAnnotationsByType(Column.class);
        String fieldName = Utils.camelToSnake(f.getName());
        if (columnAnnotations.length != 0 && (col = columnAnnotations[0]).name() != null && !col.name().isBlank()) {
            fieldName = col.name();
        }
        return fieldName;
    }

    private boolean determineNullable(Field f) {
        Column[] columnAnnotations = (Column[])f.getAnnotationsByType(Column.class);
        boolean nullable = true;
        if (columnAnnotations.length != 0) {
            Column col = columnAnnotations[0];
            nullable = col.nullable();
        }
        return nullable;
    }

    private DbField mapField(Field f, DbObjectSchema schema) {
        Enumerated enumerated;
        logger.debug("Processing field " + f.getName());
        OneToMany oneToMany = f.getAnnotation(OneToMany.class);
        ManyToMany manyToMany = f.getAnnotation(ManyToMany.class);
        ManyToOne manyToOne = f.getAnnotation(ManyToOne.class);
        OneToOne oneToOne = f.getAnnotation(OneToOne.class);
        Lob lob = f.getAnnotation(Lob.class);
        String fieldName = this.determineFieldName(f);
        Class connectedType = null;
        DbFieldType fieldType = null;
        try {
            Class<? extends DbFieldType> fieldTypeClass = DbFieldType.fromClass(f.getType());
            if (fieldTypeClass == StringFieldType.class && lob != null) {
                fieldTypeClass = TextFieldType.class;
            }
            if (fieldTypeClass != EnumFieldType.class) {
                try {
                    fieldType = fieldTypeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
            }
        }
        catch (SnapAdminException fieldTypeClass) {
            // empty catch block
        }
        if (manyToOne != null || oneToOne != null) {
            fieldName = this.mapRelationshipJoinColumn(f);
            fieldType = this.mapForeignKeyType(f.getType());
            connectedType = f.getType();
        }
        if (manyToMany != null || oneToMany != null) {
            ParameterizedType stringListType = (ParameterizedType)f.getGenericType();
            Class targetEntityClass = (Class)stringListType.getActualTypeArguments()[0];
            fieldType = this.mapForeignKeyType(targetEntityClass);
            connectedType = targetEntityClass;
        }
        if (fieldType == null && (enumerated = f.getAnnotation(Enumerated.class)) != null) {
            EnumType type = enumerated.value();
            fieldType = new EnumFieldType(f.getType(), type);
        }
        if (fieldType == null) {
            throw new UnsupportedFieldTypeException("Unable to determine fieldType for " + f.getType());
        }
        DisplayFormat displayFormat = f.getAnnotation(DisplayFormat.class);
        DbField field = new DbField(f.getName(), fieldName, f, fieldType, schema, displayFormat != null ? displayFormat.format() : null);
        field.setConnectedType(connectedType);
        Id[] idAnnotations = (Id[])f.getAnnotationsByType(Id.class);
        field.setPrimaryKey(idAnnotations.length != 0);
        field.setNullable(this.determineNullable(f));
        if (field.isPrimaryKey()) {
            field.setNullable(false);
        }
        return field;
    }

    private String mapRelationshipJoinColumn(Field f) {
        Object joinColumnName = Utils.camelToSnake(f.getName()) + "_id";
        JoinColumn[] joinColumn = (JoinColumn[])f.getAnnotationsByType(JoinColumn.class);
        if (joinColumn.length != 0) {
            joinColumnName = joinColumn[0].name();
        }
        return joinColumnName;
    }

    private DbFieldType mapForeignKeyType(Class<?> entityClass) {
        try {
            Object linkedEntity = entityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> linkType = null;
            for (Field ef : linkedEntity.getClass().getDeclaredFields()) {
                if (((Id[])ef.getAnnotationsByType(Id.class)).length == 0) continue;
                linkType = ef.getType();
            }
            if (linkType == null) {
                throw new SnapAdminException("Unable to find @Id field in Entity class " + entityClass);
            }
            return DbFieldType.fromClass(linkType).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SnapAdminException(e);
        }
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }
}

