/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external;

import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionTemplate;
import tech.ailef.snapadmin.external.SnapAdminProperties;
import tech.ailef.snapadmin.internal.InternalSnapAdminConfiguration;

@ConditionalOnProperty(name={"snapadmin.enabled"}, matchIfMissing=false)
@ComponentScan
@EnableConfigurationProperties(value={SnapAdminProperties.class})
@Configuration
@EnableJpaRepositories(entityManagerFactoryRef="internalEntityManagerFactory", basePackages={"tech.ailef.snapadmin.internal.repository"})
@EnableTransactionManagement
@Import(value={InternalSnapAdminConfiguration.class})
public class SnapAdminAutoConfiguration {
    @Autowired
    private SnapAdminProperties props;

    @Bean
    DataSource internalDataSource() {
        DataSourceBuilder dataSourceBuilder = DataSourceBuilder.create();
        dataSourceBuilder.driverClassName("org.h2.Driver");
        if (this.props.isTestMode()) {
            dataSourceBuilder.url("jdbc:h2:mem:test");
        } else {
            dataSourceBuilder.url("jdbc:h2:file:./snapadmin_internal");
        }
        dataSourceBuilder.username("sa");
        dataSourceBuilder.password("password");
        return dataSourceBuilder.build();
    }

    @Bean
    LocalContainerEntityManagerFactoryBean internalEntityManagerFactory() {
        LocalContainerEntityManagerFactoryBean factoryBean = new LocalContainerEntityManagerFactoryBean();
        factoryBean.setDataSource(this.internalDataSource());
        factoryBean.setPersistenceUnitName("internal");
        factoryBean.setPackagesToScan(new String[]{"tech.ailef.snapadmin.internal.model"});
        factoryBean.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        Properties properties = new Properties();
        properties.setProperty("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        properties.setProperty("hibernate.hbm2ddl.auto", "update");
        factoryBean.setJpaProperties(properties);
        factoryBean.afterPropertiesSet();
        return factoryBean;
    }

    PlatformTransactionManager internalTransactionManager() {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(this.internalEntityManagerFactory().getObject());
        return transactionManager;
    }

    @Bean
    TransactionTemplate internalTransactionTemplate() {
        return new TransactionTemplate(this.internalTransactionManager());
    }
}

