/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.context.ServletWebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.ailef.snapadmin.external.SnapAdmin;
import tech.ailef.snapadmin.external.SnapAdminProperties;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;

@Configuration
public class StartupAuthCheckRunner {
    private static final Logger logger = LoggerFactory.getLogger(StartupAuthCheckRunner.class);
    @Autowired
    private SnapAdmin snapAdmin;
    @Autowired
    private SnapAdminProperties properties;

    @Bean
    ApplicationListener<ServletWebServerInitializedEvent> serverPortListenerBean() {
        return event -> {
            int serverPort = event.getWebServer().getPort();
            String link = "http://localhost:" + serverPort + "/" + this.properties.getBaseUrl();
            logger.info("Checking if SnapAdmin is protected with authentication at " + link);
            try {
                URL url = new URL(link);
                HttpURLConnection openConnection = (HttpURLConnection)url.openConnection();
                openConnection.setInstanceFollowRedirects(false);
                int statusCode = openConnection.getResponseCode();
                this.snapAdmin.setAuthenticated(statusCode != 200);
                if (statusCode == 200) {
                    logger.warn("It appears that you have not enabled security so SnapAdmin is publicly accessible. Read here to learn how to secure SnapAdmin with Spring Security: https://www.snapadmin.dev/docs/#security");
                }
            }
            catch (IOException e) {
                throw new SnapAdminException(e);
            }
        };
    }
}

