/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.controller;

import java.util.Optional;
import org.apache.tika.Tika;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;
import tech.ailef.snapadmin.external.SnapAdmin;
import tech.ailef.snapadmin.external.dbmapping.DbFieldValue;
import tech.ailef.snapadmin.external.dbmapping.DbObject;
import tech.ailef.snapadmin.external.dbmapping.DbObjectSchema;
import tech.ailef.snapadmin.external.dbmapping.SnapAdminRepository;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;

@Controller
@RequestMapping(value={"/${snapadmin.baseUrl}/download", "/${snapadmin.baseUrl}/download/"})
public class FileDownloadController {
    @Autowired
    private SnapAdminRepository repository;
    @Autowired
    private SnapAdmin snapAdmin;

    @GetMapping(value={"/{className}/{fieldName}/{id}/image"}, produces={"image/jpeg"})
    @ResponseBody
    public ResponseEntity<byte[]> serveImage(@PathVariable String className, @PathVariable String fieldName, @PathVariable String id) {
        DbObjectSchema schema = this.snapAdmin.findSchemaByClassName(className);
        Optional<DbObject> object = this.repository.findById(schema, id);
        if (object.isPresent()) {
            DbObject dbObject = object.get();
            DbFieldValue dbFieldValue = dbObject.get(fieldName);
            byte[] file = (byte[])dbFieldValue.getValue();
            return ResponseEntity.ok((Object)file);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Object with id " + id + " not found");
    }

    @GetMapping(value={"/{className}/{fieldName}/{id}"})
    @ResponseBody
    public ResponseEntity<byte[]> serveFile(@PathVariable String className, @PathVariable String fieldName, @PathVariable String id) {
        DbObjectSchema schema = this.snapAdmin.findSchemaByClassName(className);
        Optional<DbObject> object = this.repository.findById(schema, id);
        if (object.isPresent()) {
            DbFieldValue dbFieldValue;
            DbObject dbObject = object.get();
            try {
                dbFieldValue = dbObject.get(fieldName);
            }
            catch (SnapAdminException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Field not found", (Throwable)e);
            }
            if (dbFieldValue.getValue() == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "There's no file attached to this item");
            }
            byte[] file = (byte[])dbFieldValue.getValue();
            String filename = schema.getClassName() + "_" + id + "_" + fieldName;
            try {
                Tika tika = new Tika();
                String detect = tika.detect(file);
                String ext = MimeTypes.getDefaultMimeTypes().forName(detect).getExtension();
                filename = filename + ext;
            }
            catch (MimeTypeException mimeTypeException) {
                // empty catch block
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + filename + "\""})).body((Object)file);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Object with id " + id + " not found");
    }
}

