/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import tech.ailef.snapadmin.external.SnapAdmin;
import tech.ailef.snapadmin.external.SnapAdminProperties;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;
import tech.ailef.snapadmin.external.exceptions.SnapAdminNotFoundException;
import tech.ailef.snapadmin.internal.UserConfiguration;

@ControllerAdvice
public class GlobalController {
    @Autowired
    private SnapAdminProperties props;
    @Autowired
    private UserConfiguration userConf;
    @Autowired
    private SnapAdmin snapAdmin;

    @ExceptionHandler(value={SnapAdminException.class})
    public String handleException(Exception e, Model model, HttpServletResponse response) {
        model.addAttribute("status", (Object)"");
        model.addAttribute("error", (Object)"Error");
        model.addAttribute("message", (Object)e.getMessage());
        model.addAttribute("snapadmin_userConf", (Object)this.userConf);
        model.addAttribute("snapadmin_baseUrl", (Object)this.getBaseUrl());
        model.addAttribute("snapadmin_version", (Object)this.snapAdmin.getVersion());
        model.addAttribute("snapadmin_properties", (Object)this.props);
        return "other/error";
    }

    @ExceptionHandler(value={SnapAdminNotFoundException.class})
    public String handleNotFound(Exception e, Model model, HttpServletResponse response) {
        model.addAttribute("status", (Object)"404");
        model.addAttribute("error", (Object)"Error");
        model.addAttribute("message", (Object)e.getMessage());
        model.addAttribute("snapadmin_userConf", (Object)this.userConf);
        model.addAttribute("snapadmin_baseUrl", (Object)this.getBaseUrl());
        model.addAttribute("snapadmin_version", (Object)this.snapAdmin.getVersion());
        model.addAttribute("snapadmin_properties", (Object)this.props);
        response.setStatus(404);
        return "other/error";
    }

    @ModelAttribute(value="snapadmin_version")
    public String getVersion() {
        return this.snapAdmin.getVersion();
    }

    @ModelAttribute(value="snapadmin_queryParams")
    public Map<String, String[]> getQueryParams(HttpServletRequest request) {
        return request.getParameterMap();
    }

    @ModelAttribute(value="snapadmin_baseUrl")
    public String getBaseUrl() {
        return this.props.getBaseUrl();
    }

    @ModelAttribute(value="snapadmin_requestUrl")
    public String getRequestUrl(HttpServletRequest request) {
        return request.getRequestURI();
    }

    @ModelAttribute(value="snapadmin_userConf")
    public UserConfiguration getUserConf() {
        return this.userConf;
    }

    @ModelAttribute(value="snapadmin_properties")
    public SnapAdminProperties getProps() {
        return this.props;
    }

    @ModelAttribute(value="snapadmin_authenticated")
    public boolean isAuthenticated() {
        return this.snapAdmin.isAuthenticated();
    }

    @ModelAttribute(value="snapadmin_authenticatedUser")
    public String authenticatedUser(Principal principal) {
        if (principal == null) {
            return null;
        }
        return principal.getName();
    }
}

