/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.controller.rest;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.ailef.snapadmin.external.SnapAdmin;
import tech.ailef.snapadmin.external.dbmapping.DbObject;
import tech.ailef.snapadmin.external.dbmapping.DbObjectSchema;
import tech.ailef.snapadmin.external.dbmapping.SnapAdminRepository;
import tech.ailef.snapadmin.external.dto.AutocompleteSearchResult;

@RestController
@RequestMapping(value={"/${snapadmin.baseUrl}/api/autocomplete", "/${snapadmin.baseUrl}/api/autocomplete/"})
public class AutocompleteController {
    @Autowired
    private SnapAdmin snapAdmin;
    @Autowired
    private SnapAdminRepository repository;

    @GetMapping(value={"/{className}"})
    public ResponseEntity<?> autocomplete(@PathVariable String className, @RequestParam String query) {
        DbObjectSchema schema = this.snapAdmin.findSchemaByClassName(className);
        List search = this.repository.search(schema, query).stream().map(x -> new AutocompleteSearchResult((DbObject)x)).collect(Collectors.toList());
        return ResponseEntity.ok(search);
    }
}

