/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dbmapping;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.web.multipart.MultipartFile;
import tech.ailef.snapadmin.external.dbmapping.DbObjectSchema;
import tech.ailef.snapadmin.external.dbmapping.fields.DbField;
import tech.ailef.snapadmin.external.dbmapping.fields.StringFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.TextFieldType;
import tech.ailef.snapadmin.external.dto.CompareOperator;
import tech.ailef.snapadmin.external.dto.QueryFilter;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;

public class CustomJpaRepository
extends SimpleJpaRepository {
    private EntityManager entityManager;
    private DbObjectSchema schema;

    public CustomJpaRepository(DbObjectSchema schema, EntityManager em) {
        super(schema.getJavaClass(), em);
        this.entityManager = em;
        this.schema = schema;
    }

    public long count(String q, Set<QueryFilter> queryFilters) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        Root root = query.from(this.schema.getJavaClass());
        List<Predicate> finalPredicates = this.buildPredicates(q, queryFilters, cb, (Path)root);
        query.select((Selection)cb.count((Expression)root.get(this.schema.getPrimaryKey().getName()))).where((Expression)cb.and(finalPredicates.toArray(new Predicate[finalPredicates.size()])));
        Object o = this.entityManager.createQuery(query).getSingleResult();
        return (Long)o;
    }

    public List<Object> search(String q, int page, int pageSize, String sortKey, String sortOrder, Set<QueryFilter> filters) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(this.schema.getJavaClass());
        Root root = query.from(this.schema.getJavaClass());
        List<Predicate> finalPredicates = this.buildPredicates(q, filters, cb, (Path)root);
        query.select((Selection)root).where((Expression)cb.or((Expression)cb.and(finalPredicates.toArray(new Predicate[finalPredicates.size()])), (Expression)cb.equal(root.get(this.schema.getPrimaryKey().getName()).as(String.class), (Object)q)));
        if (sortKey != null) {
            query.orderBy(new Order[]{sortOrder.equals("DESC") ? cb.desc((Expression)root.get(sortKey)) : cb.asc((Expression)root.get(sortKey))});
        }
        return this.entityManager.createQuery(query).setMaxResults(pageSize).setFirstResult((page - 1) * pageSize).getResultList();
    }

    public List<Object> search(String query, Set<QueryFilter> filters) {
        return this.search(query, 1, Integer.MAX_VALUE, null, null, filters);
    }

    public int update(DbObjectSchema schema, Map<String, String> params, Map<String, MultipartFile> files) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaUpdate update = cb.createCriteriaUpdate(schema.getJavaClass());
        Root root = update.from(schema.getJavaClass());
        boolean hasUpdate = false;
        for (DbField field : schema.getSortedFields()) {
            boolean keepValue;
            if (field.isPrimaryKey() || field.isReadOnly() || (keepValue = params.getOrDefault("__keep_" + field.getName(), "off").equals("on"))) continue;
            String stringValue = params.get(field.getName());
            Object value = null;
            if (stringValue != null && stringValue.isBlank()) {
                stringValue = null;
            }
            if (stringValue != null) {
                value = field.getType().parseValue(stringValue);
            } else {
                try {
                    MultipartFile file = files.get(field.getName());
                    if (file != null) {
                        value = file.isEmpty() ? null : (Object)file.getBytes();
                    }
                }
                catch (IOException e) {
                    throw new SnapAdminException(e);
                }
            }
            if (field.getConnectedSchema() != null) {
                value = field.getConnectedSchema().getJpaRepository().findById(value).get();
            }
            update.set(root.get(field.getJavaName()), value);
            hasUpdate = true;
        }
        if (!hasUpdate) {
            return 0;
        }
        String pkName = schema.getPrimaryKey().getJavaName();
        update.where((Expression)cb.equal((Expression)root.get(pkName), (Object)params.get(schema.getPrimaryKey().getName())));
        Query query = this.entityManager.createQuery(update);
        return query.executeUpdate();
    }

    private List<Predicate> buildPredicates(String q, Set<QueryFilter> queryFilters, CriteriaBuilder cb, Path root) {
        ArrayList<Predicate> finalPredicates = new ArrayList<Predicate>();
        List stringFields = this.schema.getSortedFields().stream().filter(f -> f.getType() instanceof StringFieldType || f.getType() instanceof TextFieldType).collect(Collectors.toList());
        ArrayList<Predicate> queryPredicates = new ArrayList<Predicate>();
        if (q != null && !q.isBlank()) {
            for (DbField f2 : stringFields) {
                Path path = root.get(f2.getJavaName());
                queryPredicates.add(cb.like(cb.lower(cb.toString((Expression)path)), "%" + q.toLowerCase() + "%"));
            }
            Predicate queryPredicate = cb.or(queryPredicates.toArray(new Predicate[queryPredicates.size()]));
            finalPredicates.add(queryPredicate);
        }
        if (queryFilters == null) {
            queryFilters = new HashSet<QueryFilter>();
        }
        for (QueryFilter filter : queryFilters) {
            CompareOperator op = filter.getOp();
            DbField dbField = filter.getField();
            String fieldName = dbField.getJavaName();
            String v = filter.getValue();
            Object value = null;
            if (!v.isBlank()) {
                try {
                    value = dbField.getType().parseValue(v);
                }
                catch (Exception e) {
                    throw new SnapAdminException("Invalid value `" + v + "` specified for field `" + dbField.getName() + "`");
                }
            }
            if (op == CompareOperator.STRING_EQ) {
                if (value == null) {
                    finalPredicates.add(cb.isNull((Expression)root.get(fieldName)));
                    continue;
                }
                finalPredicates.add(cb.equal(cb.lower(cb.toString((Expression)root.get(fieldName))), (Object)value.toString().toLowerCase()));
                continue;
            }
            if (op == CompareOperator.CONTAINS) {
                if (value == null) continue;
                finalPredicates.add(cb.like(cb.lower(cb.toString((Expression)root.get(fieldName))), "%" + value.toString().toLowerCase() + "%"));
                continue;
            }
            if (op == CompareOperator.EQ) {
                finalPredicates.add(cb.equal((Expression)root.get(fieldName), value));
                continue;
            }
            if (op == CompareOperator.GT) {
                if (value == null) continue;
                finalPredicates.add(cb.greaterThan((Expression)root.get(fieldName), (Comparable)((Object)value.toString())));
                continue;
            }
            if (op == CompareOperator.LT) {
                if (value == null) continue;
                finalPredicates.add(cb.lessThan((Expression)root.get(fieldName), (Comparable)((Object)value.toString())));
                continue;
            }
            if (op == CompareOperator.AFTER) {
                if (value instanceof LocalDate) {
                    finalPredicates.add(cb.greaterThan((Expression)root.get(fieldName), (Comparable)((LocalDate)value)));
                    continue;
                }
                if (!(value instanceof LocalDateTime)) continue;
                finalPredicates.add(cb.greaterThan((Expression)root.get(fieldName), (Comparable)((LocalDateTime)value)));
                continue;
            }
            if (op != CompareOperator.BEFORE) continue;
            if (value instanceof LocalDate) {
                finalPredicates.add(cb.lessThan((Expression)root.get(fieldName), (Comparable)((LocalDate)value)));
                continue;
            }
            if (!(value instanceof LocalDateTime)) continue;
            finalPredicates.add(cb.lessThan((Expression)root.get(fieldName), (Comparable)((LocalDateTime)value)));
        }
        return finalPredicates;
    }
}

