/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dbmapping;

import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import tech.ailef.snapadmin.external.annotations.DisplayName;
import tech.ailef.snapadmin.external.dbmapping.DbFieldValue;
import tech.ailef.snapadmin.external.dbmapping.DbObjectSchema;
import tech.ailef.snapadmin.external.dbmapping.fields.BooleanFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.DbField;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;

public class DbObject {
    private Object instance;
    private DbObjectSchema schema;

    public DbObject(Object instance, DbObjectSchema schema) {
        if (instance == null) {
            throw new SnapAdminException("Trying to build object with instance == null");
        }
        this.instance = instance;
        this.schema = schema;
    }

    public boolean has(DbField field) {
        return this.findGetter(field.getJavaName()) != null;
    }

    public Object getUnderlyingInstance() {
        return this.instance;
    }

    public List<DbObject> getValues(DbField field) {
        Collection values = (Collection)this.get(field.getJavaName()).getValue();
        return values.stream().map(o -> new DbObject(o, field.getConnectedSchema())).collect(Collectors.toList());
    }

    public DbFieldValue get(DbField field) {
        return this.get(field.getJavaName());
    }

    public DbObject traverse(String fieldName) {
        DbField field = this.schema.getFieldByName(fieldName);
        return this.traverse(field);
    }

    public DbObject traverse(DbField field) {
        ManyToOne manyToOne = field.getPrimitiveField().getAnnotation(ManyToOne.class);
        OneToOne oneToOne = field.getPrimitiveField().getAnnotation(OneToOne.class);
        if (oneToOne != null || manyToOne != null) {
            Object linkedObject = this.get(field.getJavaName()).getValue();
            if (linkedObject == null) {
                return null;
            }
            DbObject linkedDbObject = new DbObject(linkedObject, field.getConnectedSchema());
            return linkedDbObject;
        }
        throw new SnapAdminException("Cannot traverse field " + field.getName() + " in class " + this.schema.getClassName());
    }

    public List<DbObject> traverseMany(String fieldName) {
        DbField field = this.schema.getFieldByName(fieldName);
        return this.traverseMany(field);
    }

    public List<DbObject> traverseMany(DbField field) {
        ManyToMany manyToMany = field.getPrimitiveField().getAnnotation(ManyToMany.class);
        OneToMany oneToMany = field.getPrimitiveField().getAnnotation(OneToMany.class);
        if (manyToMany != null || oneToMany != null) {
            Collection linkedObjects = (Collection)this.get(field.getJavaName()).getValue();
            return linkedObjects.stream().map(o -> new DbObject(o, field.getConnectedSchema())).collect(Collectors.toList());
        }
        throw new SnapAdminException("Cannot traverse field " + field.getName() + " in class " + this.schema.getClassName());
    }

    public DbFieldValue get(String name) {
        Method getter = this.findGetter(name);
        if (getter == null) {
            throw new SnapAdminException("Unable to find getter method for field `" + name + "` in class " + this.instance.getClass());
        }
        try {
            Object result = getter.invoke(this.instance, new Object[0]);
            return new DbFieldValue(result, this.schema.getFieldByJavaName(name));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new SnapAdminException(e);
        }
    }

    public Object getPrimaryKeyValue() {
        DbField primaryKeyField = this.schema.getPrimaryKey();
        Method getter = this.findGetter(primaryKeyField.getJavaName());
        if (getter == null) {
            throw new SnapAdminException("Unable to find getter method for field `" + primaryKeyField.getJavaName() + "` in class " + this.instance.getClass());
        }
        try {
            Object result = getter.invoke(this.instance, new Object[0]);
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new SnapAdminException(e);
        }
    }

    public String getDisplayName() {
        Method[] methods = this.instance.getClass().getMethods();
        Optional<Method> displayNameMethod = Arrays.stream(methods).filter(m -> m.getAnnotation(DisplayName.class) != null).findFirst();
        if (displayNameMethod.isPresent()) {
            try {
                Object displayName = displayNameMethod.get().invoke(this.instance, new Object[0]);
                if (displayName == null) {
                    return null;
                }
                return displayName.toString();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new SnapAdminException(e);
            }
        }
        return this.getPrimaryKeyValue().toString();
    }

    public List<String> getComputedColumns() {
        return this.schema.getComputedColumnNames();
    }

    public DbObjectSchema getSchema() {
        return this.schema;
    }

    public Object compute(String column) {
        Method method = this.schema.getComputedColumn(column);
        if (method == null) {
            throw new SnapAdminException("Unable to find mapped method for @ComputedColumn " + column);
        }
        try {
            return method.invoke(this.instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new SnapAdminException("Error while calling @ComputedColumn " + column + " on class " + this.schema.getClassName());
        }
    }

    public void setRelationship(String fieldName, Object primaryKeyValue) {
        DbField field = this.schema.getFieldByName(fieldName);
        DbObjectSchema linkedSchema = field.getConnectedSchema();
        Optional obj = linkedSchema.getJpaRepository().findById(primaryKeyValue);
        if (!obj.isPresent()) {
            throw new SnapAdminException("Invalid value " + primaryKeyValue + " for " + fieldName + ": item does not exist.");
        }
        Method setter = this.findSetter(field.getJavaName());
        if (setter == null) {
            throw new SnapAdminException("Unable to find setter method for " + fieldName + " in " + this.schema.getClassName());
        }
        try {
            setter.invoke(this.instance, obj.get());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public void set(String fieldName, Object value) {
        Method setter = this.findSetter(fieldName);
        if (setter == null) {
            throw new SnapAdminException("Unable to find setter method for " + fieldName + " in " + this.schema.getClassName());
        }
        Class<?>[] types = setter.getParameterTypes();
        if (types.length != 1) {
            throw new SnapAdminException("Setter " + setter + " has " + types.length + " parameters (expected 1)");
        }
        Class<?> expectedSetterType = types[0];
        if (!expectedSetterType.isAssignableFrom(value.getClass())) {
            if (expectedSetterType == Set.class) {
                value = ((Collection)value).stream().collect(Collectors.toSet());
            } else if (expectedSetterType == List.class) {
                value = ((Collection)value).stream().collect(Collectors.toList());
            }
        }
        try {
            setter.invoke(this.instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            if (e instanceof IllegalArgumentException) {
                throw new RuntimeException("setter: " + setter + ", passed: " + value.getClass(), e);
            }
            throw new RuntimeException(e);
        }
    }

    protected Method findSetter(String fieldName) {
        Method[] methods;
        String capitalize = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        for (Method m : methods = this.instance.getClass().getDeclaredMethods()) {
            if (!m.getName().equals("set" + capitalize)) continue;
            return m;
        }
        return null;
    }

    protected Method findGetter(String fieldName) {
        String capitalize = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        Method[] methods = this.instance.getClass().getDeclaredMethods();
        DbField dbField = this.schema.getFieldByJavaName(fieldName);
        if (dbField == null) {
            return null;
        }
        String prefix = "get";
        if (dbField.getType() instanceof BooleanFieldType) {
            prefix = "is";
        }
        for (Method m : methods) {
            if (!m.getName().equals(prefix + capitalize)) continue;
            return m;
        }
        return null;
    }

    public Map<String, Object> toMap(List<String> fields, boolean raw) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String field : fields) {
            DbField dbField = this.schema.getFieldByName(field);
            if (dbField == null) {
                Object computedValue = this.compute(field);
                result.put(field, computedValue);
                continue;
            }
            if (dbField.isForeignKey()) {
                DbObject linkedItem = this.traverse(dbField);
                if (linkedItem == null) {
                    result.put(field, null);
                    continue;
                }
                if (raw) {
                    result.put(field, linkedItem.getPrimaryKeyValue().toString());
                    continue;
                }
                result.put(field, linkedItem.getPrimaryKeyValue() + " (" + linkedItem.getDisplayName() + ")");
                continue;
            }
            if (raw) {
                DbFieldValue fieldValue = this.get(dbField);
                if (fieldValue.getValue() == null) {
                    result.put(field, null);
                    continue;
                }
                result.put(field, fieldValue.getValue().toString());
                continue;
            }
            result.put(field, this.get(dbField).getFormattedValue());
        }
        return result;
    }

    public String toString() {
        return "DbObject [instance=" + this.instance + ", schema=" + this.schema + "]";
    }
}

