/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dbmapping;

import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import tech.ailef.snapadmin.external.SnapAdmin;
import tech.ailef.snapadmin.external.dbmapping.CustomJpaRepository;
import tech.ailef.snapadmin.external.dbmapping.DbObject;
import tech.ailef.snapadmin.external.dbmapping.DbObjectSchema;
import tech.ailef.snapadmin.external.dbmapping.fields.DbField;
import tech.ailef.snapadmin.external.dbmapping.query.DbQueryOutputField;
import tech.ailef.snapadmin.external.dbmapping.query.DbQueryResult;
import tech.ailef.snapadmin.external.dbmapping.query.DbQueryResultRow;
import tech.ailef.snapadmin.external.dto.FacetedSearchRequest;
import tech.ailef.snapadmin.external.dto.PaginatedResult;
import tech.ailef.snapadmin.external.dto.PaginationInfo;
import tech.ailef.snapadmin.external.dto.QueryFilter;
import tech.ailef.snapadmin.external.exceptions.InvalidPageException;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;

@Component
public class SnapAdminRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private SnapAdmin snapAdmin;

    public Optional<DbObject> findById(DbObjectSchema schema, Object id) {
        CustomJpaRepository repository = schema.getJpaRepository();
        Optional optional = repository.findById(id);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        DbObject obj = new DbObject(optional.get(), schema);
        return Optional.of(obj);
    }

    public long count(DbObjectSchema schema) {
        return schema.getJpaRepository().count();
    }

    public long count(DbObjectSchema schema, String query, Set<QueryFilter> queryFilters) {
        return schema.getJpaRepository().count(query, queryFilters);
    }

    public List<DbObject> search(DbObjectSchema schema, String query, Set<QueryFilter> queryFilters) {
        CustomJpaRepository jpaRepository = schema.getJpaRepository();
        return jpaRepository.search(query, queryFilters).stream().map(o -> new DbObject(o, schema)).toList();
    }

    public PaginatedResult<DbObject> findAll(DbObjectSchema schema, int page, int pageSize, String sortKey, String sortOrder) {
        CustomJpaRepository repository = schema.getJpaRepository();
        long maxElement = this.count(schema);
        int maxPage = (int)Math.ceil((double)maxElement / (double)pageSize);
        if (page <= 0) {
            page = 1;
        }
        if (page > maxPage && maxPage != 0) {
            throw new InvalidPageException();
        }
        Sort sort = null;
        if (sortKey != null) {
            sort = Sort.by((String[])new String[]{sortKey});
        }
        if (Objects.equals(sortOrder, "ASC")) {
            sort = sort.ascending();
        } else if (Objects.equals(sortOrder, "DESC")) {
            sort = sort.descending();
        }
        PageRequest pageRequestion = null;
        pageRequestion = sort != null ? PageRequest.of((int)(page - 1), (int)pageSize, (Sort)sort) : PageRequest.of((int)(page - 1), (int)pageSize);
        Page findAll = repository.findAll((Pageable)pageRequestion);
        ArrayList<DbObject> results = new ArrayList<DbObject>();
        for (Object o : findAll) {
            results.add(new DbObject(o, schema));
        }
        return new PaginatedResult<DbObject>(new PaginationInfo(page, maxPage, pageSize, maxElement, null, null), results);
    }

    @Transactional(value="transactionManager")
    public void update(DbObjectSchema schema, Map<String, String> params, Map<String, MultipartFile> files) {
        DbObject obj = schema.buildObject(params, files);
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        Set violations = validator.validate(obj.getUnderlyingInstance(), new Class[0]);
        if (violations.size() > 0) {
            throw new ConstraintViolationException(violations);
        }
        schema.getJpaRepository().update(schema, params, files);
    }

    @Transactional(value="transactionManager")
    private Object save(DbObjectSchema schema, DbObject o) {
        return schema.getJpaRepository().save(o.getUnderlyingInstance());
    }

    @Transactional(value="transactionManager")
    public void attachManyToMany(DbObjectSchema schema, Object id, Map<String, List<String>> params) {
        Optional<DbObject> optional = this.findById(schema, id);
        DbObject dbObject = optional.orElseThrow(() -> new SnapAdminException("Unable to retrieve newly inserted item"));
        for (String mParam : params.keySet()) {
            String fieldName = mParam.replace("[]", "");
            List<String> idValues = params.get(mParam);
            DbField field = schema.getFieldByName(fieldName);
            DbObjectSchema linkedSchema = field.getConnectedSchema();
            ArrayList<DbObject> traverseMany = new ArrayList<DbObject>();
            for (String oId : idValues) {
                Optional<DbObject> findById = this.findById(linkedSchema, oId);
                if (!findById.isPresent()) continue;
                traverseMany.add(findById.get());
            }
            dbObject.set(field.getJavaName(), traverseMany.stream().map(o -> o.getUnderlyingInstance()).collect(Collectors.toList()));
        }
        this.save(schema, dbObject);
    }

    @Transactional(value="transactionManager")
    public Object create(DbObjectSchema schema, Map<String, String> values, Map<String, MultipartFile> files, String primaryKey) {
        DbObject obj = schema.buildObject(values, files);
        Object save = this.save(schema, obj);
        return new DbObject(save, schema).getPrimaryKeyValue();
    }

    public PaginatedResult<DbObject> search(DbObjectSchema schema, String query, int page, int pageSize, String sortKey, String sortOrder, Set<QueryFilter> queryFilters) {
        CustomJpaRepository jpaRepository = schema.getJpaRepository();
        long maxElement = this.count(schema, query, queryFilters);
        int maxPage = (int)Math.ceil((double)maxElement / (double)pageSize);
        if (page <= 0) {
            page = 1;
        }
        if (page > maxPage && maxPage != 0) {
            throw new InvalidPageException();
        }
        return new PaginatedResult<DbObject>(new PaginationInfo(page, maxPage, pageSize, maxElement, query, new FacetedSearchRequest(queryFilters)), jpaRepository.search(query, page, pageSize, sortKey, sortOrder, queryFilters).stream().map(o -> new DbObject(o, schema)).toList());
    }

    public List<DbObject> search(DbObjectSchema schema, String query) {
        CustomJpaRepository jpaRepository = schema.getJpaRepository();
        return jpaRepository.search(query, 1, 50, null, null, null).stream().map(o -> new DbObject(o, schema)).toList();
    }

    public DbQueryResult executeQuery(String sql) {
        List<DbQueryResultRow> results = new ArrayList<DbQueryResultRow>();
        if (sql != null && !sql.isBlank()) {
            try {
                results = this.jdbcTemplate.query(sql, (rs, rowNum) -> {
                    HashMap<DbQueryOutputField, Object> result = new HashMap<DbQueryOutputField, Object>();
                    ResultSetMetaData metaData = rs.getMetaData();
                    int cols = metaData.getColumnCount();
                    for (int i = 0; i < cols; ++i) {
                        Object o = rs.getObject(i + 1);
                        String columnName = metaData.getColumnName(i + 1);
                        String tableName = metaData.getTableName(i + 1);
                        DbQueryOutputField field = new DbQueryOutputField(columnName, tableName, this.snapAdmin);
                        result.put(field, o);
                    }
                    DbQueryResultRow row = new DbQueryResultRow(result, sql);
                    result.keySet().forEach(f -> f.setResult(row));
                    return row;
                });
            }
            catch (TransientDataAccessResourceException transientDataAccessResourceException) {
                // empty catch block
            }
        }
        return new DbQueryResult(results);
    }

    @Transactional(value="transactionManager")
    public void delete(DbObjectSchema schema, String id) {
        schema.getJpaRepository().deleteById(id);
    }
}

