/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dbmapping.fields;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;
import tech.ailef.snapadmin.external.dbmapping.fields.BigDecimalFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.BigIntegerFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.BooleanFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.ByteArrayFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.ByteFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.CharFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.DateFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.DoubleFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.EnumFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.FloatFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.InstantFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.IntegerFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.LocalDateFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.LocalDateTimeFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.LongFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.OffsetDateTimeFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.ShortFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.StringFieldType;
import tech.ailef.snapadmin.external.dbmapping.fields.UUIDFieldType;
import tech.ailef.snapadmin.external.dto.CompareOperator;
import tech.ailef.snapadmin.external.exceptions.UnsupportedFieldTypeException;
import tech.ailef.snapadmin.external.misc.Utils;

public abstract class DbFieldType {
    public abstract String getFragmentName();

    public abstract Object parseValue(Object var1);

    public abstract Class<?> getJavaClass();

    public abstract List<CompareOperator> getCompareOperators();

    public List<?> getValues() {
        throw new UnsupportedOperationException("getValues only supported on Enum type: called on " + this.getClass().getSimpleName());
    }

    public String toString() {
        return Utils.camelToSnake(this.getClass().getSimpleName().replace("FieldType", "")).toUpperCase();
    }

    public boolean isRelationship() {
        return false;
    }

    public static Class<? extends DbFieldType> fromClass(Class<?> klass) {
        if (klass == Boolean.class || klass == Boolean.TYPE) {
            return BooleanFieldType.class;
        }
        if (klass == Long.class || klass == Long.TYPE) {
            return LongFieldType.class;
        }
        if (klass == Integer.class || klass == Integer.TYPE) {
            return IntegerFieldType.class;
        }
        if (klass == BigInteger.class) {
            return BigIntegerFieldType.class;
        }
        if (klass == Short.class || klass == Short.TYPE) {
            return ShortFieldType.class;
        }
        if (klass == String.class) {
            return StringFieldType.class;
        }
        if (klass == LocalDate.class) {
            return LocalDateFieldType.class;
        }
        if (klass == Date.class) {
            return DateFieldType.class;
        }
        if (klass == LocalDateTime.class) {
            return LocalDateTimeFieldType.class;
        }
        if (klass == Instant.class) {
            return InstantFieldType.class;
        }
        if (klass == Float.class || klass == Float.TYPE) {
            return FloatFieldType.class;
        }
        if (klass == Double.class || klass == Double.TYPE) {
            return DoubleFieldType.class;
        }
        if (klass == BigDecimal.class) {
            return BigDecimalFieldType.class;
        }
        if (klass == byte[].class) {
            return ByteArrayFieldType.class;
        }
        if (klass == OffsetDateTime.class) {
            return OffsetDateTimeFieldType.class;
        }
        if (klass == Byte.TYPE || klass == Byte.class) {
            return ByteFieldType.class;
        }
        if (klass == UUID.class) {
            return UUIDFieldType.class;
        }
        if (klass == Character.TYPE || klass == Character.class) {
            return CharFieldType.class;
        }
        if (Enum.class.isAssignableFrom(klass)) {
            return EnumFieldType.class;
        }
        throw new UnsupportedFieldTypeException("Unsupported field type: " + klass);
    }
}

