/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dbmapping.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.ailef.snapadmin.external.dbmapping.query.DbQueryOutputField;
import tech.ailef.snapadmin.external.exceptions.SnapAdminException;

public class DbQueryResultRow {
    private Map<DbQueryOutputField, Object> values;
    private String query;

    public DbQueryResultRow(Map<DbQueryOutputField, Object> values, String query) {
        this.values = values;
        this.query = query;
    }

    public List<DbQueryOutputField> getSortedFields() {
        return this.values.keySet().stream().sorted((f1, f2) -> {
            if (f1.isPrimaryKey() && !f2.isPrimaryKey()) {
                return -1;
            }
            if (!f1.isPrimaryKey() && f2.isPrimaryKey()) {
                return 1;
            }
            return f1.getName().compareTo(f2.getName());
        }).toList();
    }

    public String getQuery() {
        return this.query;
    }

    public Object get(DbQueryOutputField field) {
        return this.values.get(field);
    }

    public Object getFieldByName(String field) {
        DbQueryOutputField key = this.values.keySet().stream().filter(f -> f.getName().equals(field)).findFirst().orElse(null);
        if (key == null) {
            throw new SnapAdminException("Field " + field + " not found");
        }
        return this.get(key);
    }

    public Map<String, Object> toMap(List<String> fields) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String field : fields) {
            result.put(field, this.getFieldByName(field));
        }
        return result;
    }
}

