/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.external.dto;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidationErrorsContainer {
    private Map<String, List<ConstraintViolation<?>>> errors = new HashMap();

    public ValidationErrorsContainer(ConstraintViolationException e) {
        e.getConstraintViolations().forEach(c -> {
            this.errors.putIfAbsent(c.getPropertyPath().toString(), new ArrayList());
            this.errors.get(c.getPropertyPath().toString()).add((ConstraintViolation<?>)c);
        });
    }

    public List<ConstraintViolation<?>> forField(String name) {
        return this.errors.getOrDefault(name, new ArrayList());
    }

    public boolean hasErrors(String name) {
        return this.forField(name).size() > 0;
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    public String toString() {
        return "ValidationErrorsContainer [errors=" + this.errors + "]";
    }
}

