/*
 * Decompiled with CFR 0.152.
 */
package tech.ailef.snapadmin.internal.service;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import tech.ailef.snapadmin.external.dto.LogsSearchRequest;
import tech.ailef.snapadmin.external.dto.PaginatedResult;
import tech.ailef.snapadmin.external.dto.PaginationInfo;
import tech.ailef.snapadmin.internal.model.UserAction;
import tech.ailef.snapadmin.internal.repository.CustomActionRepositoryImpl;
import tech.ailef.snapadmin.internal.repository.UserActionRepository;

@Service
public class UserActionService {
    @Autowired
    private UserActionRepository repo;
    @Autowired
    private CustomActionRepositoryImpl customRepo;
    @Autowired
    private TransactionTemplate internalTransactionTemplate;

    public UserAction save(UserAction a) {
        return (UserAction)this.internalTransactionTemplate.execute(status -> (UserAction)this.repo.save(a));
    }

    public PaginatedResult<UserAction> findActions(LogsSearchRequest request) {
        PageRequest page = request.toPageRequest();
        long count = this.customRepo.countActions(request);
        List<UserAction> actions = this.customRepo.findActions(request);
        int maxPage = (int)Math.ceil((double)count / (double)page.getPageSize());
        return new PaginatedResult<UserAction>(new PaginationInfo(page.getPageNumber() + 1, maxPage, page.getPageSize(), count, null, request), actions);
    }
}

