/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.Conversion;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.NoWrappingJsonEncoder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import tech.allegro.schema.json2avro.converter.AvroConversionException;

public class AvroJsonConverter {
    private final SpecificData specificData = new SpecificData();
    private final GenericData genericData = new GenericData();

    public AvroJsonConverter(Conversion<?> ... conversions) {
        Arrays.stream(conversions).forEach(it -> {
            this.specificData.addLogicalTypeConversion(it);
            this.genericData.addLogicalTypeConversion(it);
        });
    }

    public byte[] convertToJson(byte[] avro, String schema) {
        return this.convertToJson(avro, new Schema.Parser().parse(schema));
    }

    public byte[] convertToJson(byte[] avro, Schema schema) {
        try {
            BinaryDecoder binaryDecoder = DecoderFactory.get().binaryDecoder(avro, null);
            GenericRecord record = (GenericRecord)new GenericDatumReader(schema, schema, this.genericData).read(null, (Decoder)binaryDecoder);
            return this.convertToJson(record);
        }
        catch (IOException e) {
            throw new AvroConversionException("Failed to create avro structure.", e);
        }
    }

    public byte[] convertToJson(GenericRecord record) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            NoWrappingJsonEncoder jsonEncoder = new NoWrappingJsonEncoder(record.getSchema(), outputStream);
            SpecificDatumWriter writer = record instanceof SpecificRecord ? new SpecificDatumWriter(record.getSchema(), this.specificData) : new GenericDatumWriter(record.getSchema(), this.genericData);
            writer.write((Object)record, (Encoder)jsonEncoder);
            jsonEncoder.flush();
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new AvroConversionException("Failed to convert to JSON.", e);
        }
    }
}

