/*
 * Decompiled with CFR 0.152.
 */
package tech.blueglacier.email;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.message.MaximalBodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.blueglacier.configuration.AppConfig;
import tech.blueglacier.email.Attachment;
import tech.blueglacier.email.CalendarBody;
import tech.blueglacier.email.CustomUnstructuredFieldImpl;
import tech.blueglacier.email.EmailAttachment;
import tech.blueglacier.email.EmailMessageType;
import tech.blueglacier.email.HtmlEmailBody;
import tech.blueglacier.email.MultipartType;
import tech.blueglacier.email.PlainTextEmailBody;
import tech.blueglacier.util.Common;

public class Email {
    private Header header;
    private ArrayList<Attachment> attachments;
    private Attachment plainTextEmailBody;
    private Attachment htmlEmailBody;
    private Attachment calendarBody;
    private boolean attachmentReplacedInHtmlBody = false;
    private Stack<MultipartType> multipartStack;
    private Stack<EmailMessageType> emailMessageStack;
    private int decodedEmailSize = 0;
    private int emailSize = 0;
    Logger LOGGER = LoggerFactory.getLogger(Email.class);

    public int getEmailSize() {
        return this.emailSize;
    }

    public int getDecodedEmailSize() {
        return this.decodedEmailSize;
    }

    public Email() {
        this.header = new HeaderImpl();
        this.attachments = new ArrayList();
        this.multipartStack = new Stack();
        this.emailMessageStack = new Stack();
    }

    public Header getHeader() {
        return this.header;
    }

    public Attachment getPlainTextEmailBody() {
        return this.plainTextEmailBody;
    }

    public void fillEmailContents(BodyDescriptor bd, InputStream is) {
        this.LOGGER.info("mime part received");
        if (!(this.addPlainTextEmailBody(bd, is) || this.addHTMLEmailBody(bd, is) || this.addCalendar(bd, is))) {
            this.addAttachments(bd, is);
        }
    }

    private boolean addCalendar(BodyDescriptor bd, InputStream is) {
        boolean isBodySet = false;
        BodyDescriptor calendarBodyDescriptor = bd;
        if (this.calendarBody == null && this.isCalendarBody(calendarBodyDescriptor)) {
            this.calendarBody = new CalendarBody(bd, is);
            isBodySet = true;
            this.LOGGER.info("Email calendar body identified");
        }
        return isBodySet;
    }

    private boolean shouldIgnore(BodyDescriptor bd, InputStream is) {
        boolean shouldIgnore;
        String attachmentName = Common.getAttachmentName(bd);
        boolean bl = shouldIgnore = attachmentName == null;
        if (shouldIgnore) {
            this.LOGGER.info("ignored mime part for attachment consideration");
        }
        return shouldIgnore;
    }

    public Stack<MultipartType> getMultipartStack() {
        return this.multipartStack;
    }

    public Stack<EmailMessageType> getMessageStack() {
        return this.emailMessageStack;
    }

    public String getEmailSubject() {
        Field subjectField = this.header.getField("Subject");
        if (subjectField != null) {
            CustomUnstructuredFieldImpl decodedSubjectField = new CustomUnstructuredFieldImpl(subjectField, DecodeMonitor.SILENT);
            return decodedSubjectField.getValue();
        }
        return null;
    }

    public String getToEmailHeaderValue() {
        Field to = this.header.getField("To");
        if (to != null) {
            return to.getBody();
        }
        return null;
    }

    public String getCCEmailHeaderValue() {
        Field cc = this.header.getField("Cc");
        if (cc != null) {
            return cc.getBody();
        }
        return null;
    }

    public String getFromEmailHeaderValue() {
        Field from = this.header.getField("From");
        if (from != null) {
            return from.getBody();
        }
        return null;
    }

    private void addAttachments(BodyDescriptor bd, InputStream is) {
        this.attachments.add(new EmailAttachment(bd, is));
        this.LOGGER.info("Email attachment identified");
    }

    private void addAttachments(Attachment attachment) {
        this.attachments.add(attachment);
        this.LOGGER.info("Email attachment identified");
    }

    private boolean addHTMLEmailBody(BodyDescriptor bd, InputStream is) {
        boolean isBodySet = false;
        BodyDescriptor emailHTMLBodyDescriptor = bd;
        if (this.htmlEmailBody == null) {
            if (this.isHTMLBody(emailHTMLBodyDescriptor)) {
                this.htmlEmailBody = new HtmlEmailBody(bd, is);
                isBodySet = true;
                this.LOGGER.info("Email html body identified");
            }
        } else if (this.isHTMLBody(emailHTMLBodyDescriptor)) {
            if (this.multipartStack.peek().getBodyDescriptor().getMimeType().equalsIgnoreCase("multipart/mixed")) {
                InputStream mainInputStream;
                try {
                    mainInputStream = this.concatInputStream(is, this.htmlEmailBody.getIs());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.htmlEmailBody.setIs(mainInputStream);
            } else {
                this.addAttachments(new HtmlEmailBody(bd, is));
            }
            isBodySet = true;
        }
        return isBodySet;
    }

    private boolean isHTMLBody(BodyDescriptor emailHTMLBodyDescriptor) {
        String bodyName = Common.getAttachmentName(emailHTMLBodyDescriptor);
        return emailHTMLBodyDescriptor.getMimeType().equalsIgnoreCase("text/html") && bodyName == null;
    }

    private boolean isCalendarBody(BodyDescriptor emailCalendarBodyDescriptor) {
        String bodyName = Common.getAttachmentName(emailCalendarBodyDescriptor);
        return emailCalendarBodyDescriptor.getMimeType().equalsIgnoreCase("text/calendar") && bodyName == null;
    }

    private boolean addPlainTextEmailBody(BodyDescriptor bd, InputStream is) {
        boolean isBodySet = false;
        BodyDescriptor emailPlainBodyDescriptor = bd;
        if (this.plainTextEmailBody == null) {
            if (this.isPlainTextBody(emailPlainBodyDescriptor)) {
                this.plainTextEmailBody = new PlainTextEmailBody(bd, is);
                isBodySet = true;
                this.LOGGER.info("Email plain text body identified");
            }
        } else if (this.isPlainTextBody(emailPlainBodyDescriptor)) {
            if (this.multipartStack.peek().getBodyDescriptor().getMimeType().equalsIgnoreCase("multipart/mixed")) {
                InputStream mainInputStream;
                try {
                    mainInputStream = this.concatInputStream(is, this.plainTextEmailBody.getIs());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.plainTextEmailBody.setIs(mainInputStream);
            } else {
                this.addAttachments(new PlainTextEmailBody(bd, is));
            }
            isBodySet = true;
        }
        return isBodySet;
    }

    private boolean isPlainTextBody(BodyDescriptor emailPlainBodyDescriptor) {
        String bodyName = Common.getAttachmentName(emailPlainBodyDescriptor);
        return emailPlainBodyDescriptor.getMimeType().equalsIgnoreCase("text/plain") && bodyName == null;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public Attachment getHTMLEmailBody() {
        return this.htmlEmailBody;
    }

    public Attachment getCalendarBody() {
        return this.calendarBody;
    }

    public void reArrangeEmail() {
        this.decodedEmailSize = this.setEmailSize();
        this.replaceInlineImageAttachmentsInHtmlBody();
        this.removeUnidentifiedMimePartsForAttachment();
        this.emailSize = this.setEmailSize();
    }

    private int setEmailSize() {
        int emailSize = 0;
        if (this.getHTMLEmailBody() != null) {
            emailSize += this.getHTMLEmailBody().getAttachmentSize();
        }
        if (this.getPlainTextEmailBody() != null) {
            emailSize += this.getPlainTextEmailBody().getAttachmentSize();
        }
        if (this.getCalendarBody() != null) {
            emailSize += this.getCalendarBody().getAttachmentSize();
        }
        for (Attachment attachment : this.getAttachments()) {
            emailSize += attachment.getAttachmentSize();
        }
        return emailSize;
    }

    private void removeUnidentifiedMimePartsForAttachment() {
        ArrayList<Attachment> removeList = new ArrayList<Attachment>();
        for (Attachment attachment : this.attachments) {
            if (!this.shouldIgnore(attachment.bd, attachment.getIs())) continue;
            removeList.add(attachment);
        }
        this.removeAttachments(removeList);
    }

    private void replaceInlineImageAttachmentsInHtmlBody() {
        if (this.htmlEmailBody != null) {
            String strHTMLBody = this.getHtmlBodyString();
            ArrayList<Attachment> removalList = new ArrayList<Attachment>();
            for (int i = 0; i < this.attachments.size(); ++i) {
                Attachment attachment = this.attachments.get(i);
                if (!this.isImage(attachment)) continue;
                String contentId = this.getAttachmentContentID(attachment);
                strHTMLBody = this.replaceAttachmentInHtmlBody(strHTMLBody, removalList, attachment, contentId);
            }
            this.removeAttachments(removalList);
            this.resetRecreatedHtmlBody(strHTMLBody);
            this.LOGGER.info("Finished embedding images in html");
        }
    }

    private String replaceAttachmentInHtmlBody(String strHTMLBody, List<Attachment> removalList, Attachment attachment, String contentId) {
        if (strHTMLBody.contains("cid:" + contentId)) {
            String base64EncodedAttachment = null;
            try {
                base64EncodedAttachment = Base64.encodeBase64String((byte[])IOUtils.toByteArray((InputStream)attachment.getIs()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            strHTMLBody = strHTMLBody.replace("cid:" + contentId, "data:;base64," + base64EncodedAttachment);
            removalList.add(attachment);
            this.attachmentReplacedInHtmlBody = true;
        }
        return strHTMLBody;
    }

    private boolean isImage(Attachment attachment) {
        return ((MaximalBodyDescriptor)attachment.getBd()).getMediaType().equalsIgnoreCase("image") || AppConfig.getInstance().isImageFormat(attachment.getAttachmentName());
    }

    public boolean isAttachmentReplacedInHtmlBody() {
        return this.attachmentReplacedInHtmlBody;
    }

    private void resetRecreatedHtmlBody(String strHTMLBody) {
        try {
            this.htmlEmailBody.setIs(new ByteArrayInputStream(strHTMLBody.getBytes(this.getCharSet())));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeAttachments(List<Attachment> removalList) {
        this.attachments.removeAll(removalList);
    }

    private String getAttachmentContentID(Attachment attachment) {
        String contentId = ((MaximalBodyDescriptor)attachment.getBd()).getContentId();
        contentId = this.stripContentID(contentId);
        return contentId;
    }

    private String stripContentID(String contentId) {
        contentId = StringUtils.stripStart((String)contentId, (String)"<");
        contentId = StringUtils.stripEnd((String)contentId, (String)">");
        return contentId;
    }

    private String getHtmlBodyString() {
        String strHTMLBody = "";
        try {
            String charSet = this.getCharSet();
            strHTMLBody = this.convertStreamToString(this.htmlEmailBody.getIs(), charSet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return strHTMLBody;
    }

    private String getCharSet() {
        String charSet = Common.getFallbackCharset(this.htmlEmailBody.getBd().getCharset());
        return charSet;
    }

    private String convertStreamToString(InputStream is, String charSet) throws IOException {
        if (is != null) {
            return IOUtils.toString((InputStream)is, (String)charSet);
        }
        return "";
    }

    private InputStream concatInputStream(InputStream source, InputStream destination) throws IOException {
        return new SequenceInputStream(destination, source);
    }
}

