/*
 * Decompiled with CFR 0.152.
 */
package tech.blueglacier.configuration;

import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.io.FilenameUtils;

public class AppConfig {
    private static volatile AppConfig objectInstance = null;
    private Configuration appConfig;
    private Properties charSetMap = null;

    private AppConfig() {
        try {
            this.appConfig = new XMLConfiguration(this.getClass().getClassLoader().getResource("conf/emailParserConfig.xml"));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppConfig getInstance() {
        if (objectInstance != null) return objectInstance;
        Class<AppConfig> clazz = AppConfig.class;
        synchronized (AppConfig.class) {
            if (objectInstance != null) return objectInstance;
            objectInstance = new AppConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return objectInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties getCharSetMap() {
        if (this.charSetMap != null) return this.charSetMap;
        Class<AppConfig> clazz = AppConfig.class;
        synchronized (AppConfig.class) {
            if (this.charSetMap != null) return this.charSetMap;
            this.charSetMap = new Properties();
            String[] arrStr = this.appConfig.getStringArray("appSettings.charSetFallback");
            for (int i = 0; i < arrStr.length; ++i) {
                String temp = arrStr[i];
                String parentCharSet = temp.substring(temp.indexOf(58) + 1, temp.length());
                temp = temp.substring(0, temp.indexOf(58));
                String[] arrChild = temp.split(",");
                for (int j = 0; j < arrChild.length; ++j) {
                    this.charSetMap.setProperty(arrChild[j].toLowerCase(), parentCharSet);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.charSetMap;
        }
    }

    public boolean isImageFormat(String fileName) {
        if (fileName != null && !fileName.isEmpty()) {
            String[] arrImageFormat = this.appConfig.getStringArray("appSettings.imageFileFormats");
            return FilenameUtils.isExtension((String)fileName.toLowerCase(), (String[])arrImageFormat);
        }
        return false;
    }
}

