/*
 * Decompiled with CFR 0.152.
 */
package tech.blueglacier.disposition;

import com.sun.mail.util.PropUtil;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.util.CharsetUtil;
import tech.blueglacier.Common;

public class ContentDispositionDecoder {
    private static boolean decodeParametersStrict = PropUtil.getBooleanSystemProperty((String)"mail.mime.decodeparameters.strict", (boolean)false);

    private static ContentDispositionHeaderValue decodeContentDisposition(String headerValue) throws MimeException {
        ContentDispositionHeaderValue contentDispositionHeaderValue;
        block9: {
            contentDispositionHeaderValue = new ContentDispositionHeaderValue();
            contentDispositionHeaderValue.setValue(headerValue);
            try {
                int i = headerValue.indexOf(39);
                if (i <= 0) {
                    if (decodeParametersStrict) {
                        throw new MimeException("Missing charset in encoded value: " + headerValue);
                    }
                    return contentDispositionHeaderValue;
                }
                String charset = headerValue.substring(0, i);
                if (CharsetUtil.lookup((String)(charset = Common.getFallbackCharset(charset))) == null) {
                    return contentDispositionHeaderValue;
                }
                int li = headerValue.indexOf(39, i + 1);
                if (li < 0) {
                    if (decodeParametersStrict) {
                        throw new MimeException("Missing language in encoded value: " + headerValue);
                    }
                    return contentDispositionHeaderValue;
                }
                headerValue = headerValue.substring(li + 1);
                contentDispositionHeaderValue.setCharset(charset);
                contentDispositionHeaderValue.setValue(ContentDispositionDecoder.decodeBytes(headerValue, charset));
            }
            catch (NumberFormatException nex) {
                if (decodeParametersStrict) {
                    throw new MimeException((Throwable)nex);
                }
            }
            catch (StringIndexOutOfBoundsException ex) {
                if (!decodeParametersStrict) break block9;
                throw new MimeException((Throwable)ex);
            }
        }
        return contentDispositionHeaderValue;
    }

    private static String decodeBytes(String value, String charset) throws MimeException {
        String str;
        byte[] b = new byte[value.length()];
        int temp = 0;
        int bi = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '%') {
                String hex = value.substring(i + 1, i + 3);
                c = (char)Integer.parseInt(hex, 16);
                i += 2;
            }
            b[bi++] = (byte)c;
            temp = bi;
        }
        try {
            str = new String(b, 0, temp, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new MimeException((Throwable)e);
        }
        return str;
    }

    public static String decodeDispositionFileName(Map<String, String> contentDispositionParameters) throws MimeException {
        Set<String> contentDispositionKeySet = contentDispositionParameters.keySet();
        String fileName = null;
        if (contentDispositionKeySet != null) {
            String[] sortedDispositionFileNameKeys = ContentDispositionDecoder.getSortedStringArray(contentDispositionKeySet.toArray());
            StringBuilder valueStr = new StringBuilder();
            for (int i = 0; i < sortedDispositionFileNameKeys.length; ++i) {
                valueStr.append(contentDispositionParameters.get(sortedDispositionFileNameKeys[i]));
            }
            String encodedStr = valueStr.toString();
            if (!encodedStr.isEmpty()) {
                fileName = ContentDispositionDecoder.decodeContentDisposition(encodedStr).getValue();
            }
        }
        return fileName;
    }

    private static String[] getSortedStringArray(Object[] objArray) {
        Object[] strArray = new String[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            strArray[i] = (String)objArray[i];
        }
        Arrays.sort(strArray);
        return strArray;
    }

    private static class ContentDispositionHeaderValue {
        private String value;
        private String charset;

        private ContentDispositionHeaderValue() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }
    }
}

