/*
 * Decompiled with CFR 0.152.
 */
package tech.blueglacier.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.codec.Base64InputStream;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;
import org.apache.james.mime4j.util.CharsetUtil;
import tech.blueglacier.util.Common;

public class MimeWordDecoder {
    private static Log log = LogFactory.getLog(DecoderUtil.class);
    private static final Pattern PATTERN_ENCODED_WORD = Pattern.compile("(.*?)=\\?([^\\?]+?)\\?(\\w)\\?([^\\?]+?)\\?=", 32);

    public static String decodeEncodedWords(String body, DecodeMonitor monitor) throws IllegalArgumentException {
        if (body != null && !body.isEmpty()) {
            int tailIndex = 0;
            boolean lastMatchValid = false;
            StringBuilder sb = new StringBuilder();
            Matcher matcher = PATTERN_ENCODED_WORD.matcher(body);
            while (matcher.find()) {
                String separator = matcher.group(1);
                String mimeCharset = matcher.group(2);
                String encoding = matcher.group(3);
                String encodedText = matcher.group(4);
                mimeCharset = Common.getFallbackCharset(mimeCharset);
                String decoded = null;
                decoded = MimeWordDecoder.tryDecodeEncodedWord(mimeCharset, encoding, encodedText, monitor);
                if (decoded == null) {
                    sb.append(matcher.group(0));
                } else {
                    if (!lastMatchValid || !CharsetUtil.isWhitespace((String)separator)) {
                        sb.append(separator);
                    }
                    sb.append(decoded);
                }
                tailIndex = matcher.end();
                lastMatchValid = decoded != null;
            }
            if (tailIndex == 0) {
                return body;
            }
            sb.append(body.substring(tailIndex));
            return sb.toString();
        }
        return body;
    }

    private static String tryDecodeEncodedWord(String mimeCharset, String encoding, String encodedText, DecodeMonitor monitor) {
        Charset charset = CharsetUtil.lookup((String)mimeCharset);
        if (charset == null) {
            MimeWordDecoder.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Mime charser '", mimeCharset, "' doesn't have a corresponding Java charset");
            return null;
        }
        if (encodedText.length() == 0) {
            MimeWordDecoder.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Missing encoded text in encoded word");
            return null;
        }
        try {
            if (encoding.equalsIgnoreCase("Q")) {
                return MimeWordDecoder.decodeQ(encodedText, charset.name(), monitor);
            }
            if (encoding.equalsIgnoreCase("B")) {
                return MimeWordDecoder.decodeB(encodedText, charset.name(), monitor);
            }
            MimeWordDecoder.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Warning: Unknown encoding in encoded word");
            return null;
        }
        catch (UnsupportedEncodingException e) {
            MimeWordDecoder.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Unsupported encoding (", e.getMessage(), ") in encoded word");
            return null;
        }
        catch (RuntimeException e) {
            MimeWordDecoder.monitor(monitor, mimeCharset, encoding, encodedText, "leaving word encoded", "Could not decode (", e.getMessage(), ") encoded word");
            return null;
        }
    }

    private static void monitor(DecodeMonitor monitor, String mimeCharset, String encoding, String encodedText, String dropDesc, String ... strings) throws IllegalArgumentException {
        if (monitor.isListening()) {
            String encodedWord = MimeWordDecoder.recombine(mimeCharset, encoding, encodedText);
            StringBuilder text = new StringBuilder();
            for (String str : strings) {
                text.append(str);
            }
            text.append(" (");
            text.append(encodedWord);
            text.append(")");
            String exceptionDesc = text.toString();
            if (monitor.warn(exceptionDesc, dropDesc)) {
                throw new IllegalArgumentException(text.toString());
            }
        }
    }

    private static String recombine(String mimeCharset, String encoding, String encodedText) {
        return "=?" + mimeCharset + "?" + encoding + "?" + encodedText + "?=";
    }

    static String decodeQ(String encodedText, String charset, DecodeMonitor monitor) throws UnsupportedEncodingException {
        encodedText = MimeWordDecoder.replaceUnderscores(encodedText);
        byte[] decodedBytes = MimeWordDecoder.decodeQuotedPrintable(encodedText, monitor);
        return new String(decodedBytes, charset);
    }

    static String decodeB(String encodedText, String charset, DecodeMonitor monitor) throws UnsupportedEncodingException {
        byte[] decodedBytes = MimeWordDecoder.decodeBase64(encodedText, monitor);
        return new String(decodedBytes, charset);
    }

    private static byte[] decodeBase64(String s, DecodeMonitor monitor) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] bytes = s.getBytes("US-ASCII");
            Base64InputStream is = new Base64InputStream((InputStream)new ByteArrayInputStream(bytes), monitor);
            int b = 0;
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return baos.toByteArray();
    }

    private static String replaceUnderscores(String str) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '_') {
                sb.append("=20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static byte[] decodeQuotedPrintable(String s, DecodeMonitor monitor) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] bytes = s.getBytes("US-ASCII");
            QuotedPrintableInputStream is = new QuotedPrintableInputStream((InputStream)new ByteArrayInputStream(bytes), monitor);
            int b = 0;
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return baos.toByteArray();
    }
}

