/*
 * Decompiled with CFR 0.152.
 */
package tech.blueglacier.parser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import tech.blueglacier.email.Email;
import tech.blueglacier.email.EmailMessageType;
import tech.blueglacier.email.MultipartType;

public class CustomContentHandler
extends AbstractContentHandler {
    private Email email = new Email();

    public Email getEmail() {
        return this.email;
    }

    public void field(Field field) throws MimeException {
        this.email.getHeader().addField(field);
    }

    public void body(BodyDescriptor bd, InputStream is) throws MimeException, IOException {
        if (this.email.getMessageStack().peek().getEmailMessageTypeHierarchy() == EmailMessageType.EmailMessageTypeHierarchy.parent) {
            this.email.fillEmailContents(bd, is);
        }
    }

    public void startMessage() throws MimeException {
        if (this.email.getMessageStack().empty()) {
            this.email.getMessageStack().push(new EmailMessageType(EmailMessageType.EmailMessageTypeHierarchy.parent));
        } else {
            this.email.getMessageStack().push(new EmailMessageType(EmailMessageType.EmailMessageTypeHierarchy.child));
        }
    }

    public void endMessage() {
        if (this.email.getMessageStack().peek().getEmailMessageTypeHierarchy() == EmailMessageType.EmailMessageTypeHierarchy.parent) {
            this.email.reArrangeEmail();
        }
        this.email.getMessageStack().pop();
    }

    public void endMultipart() throws MimeException {
        this.email.getMultipartStack().pop();
    }

    public void startMultipart(BodyDescriptor bd) throws MimeException {
        this.email.getMultipartStack().push(new MultipartType(bd));
    }
}

