/*
 * Decompiled with CFR 0.152.
 */
package tech.blueglacier.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.storage.Storage;
import org.apache.james.mime4j.storage.StorageOutputStream;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import tech.blueglacier.storage.AbstractStorageProvider;

public class MemoryStorageProvider
extends AbstractStorageProvider {
    public StorageOutputStream createStorageOutputStream() {
        return new MemoryStorageOutputStream();
    }

    static final class MemoryStorage
    implements Storage {
        private byte[] data;
        private final int count;

        public MemoryStorage(byte[] data, int count) {
            this.data = data;
            this.count = count;
        }

        public InputStream getInputStream() throws IOException {
            if (this.data == null) {
                throw new IllegalStateException("tech.blueglacier.storage has been deleted");
            }
            return new ByteArrayInputStream(this.data, 0, this.count);
        }

        public void delete() {
            this.data = null;
        }
    }

    private static final class MemoryStorageOutputStream
    extends StorageOutputStream {
        ByteArrayBuffer bab = new ByteArrayBuffer(1024);

        private MemoryStorageOutputStream() {
        }

        protected void write0(byte[] buffer, int offset, int length) throws IOException {
            this.bab.append(buffer, offset, length);
        }

        protected Storage toStorage0() throws IOException {
            return new MemoryStorage(this.bab.buffer(), this.bab.length());
        }
    }
}

