/*
 * Decompiled with CFR 0.152.
 */
package tech.blueglacier.email;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.storage.Storage;
import org.apache.james.mime4j.stream.BodyDescriptor;
import tech.blueglacier.storage.AbstractStorageProvider;
import tech.blueglacier.storage.MemoryStorageProvider;

public abstract class Attachment {
    protected BodyDescriptor bd;
    private InputStream is;
    private Storage storage;
    private int attachmentSize;

    public abstract String getAttachmentName();

    public BodyDescriptor getBd() {
        return this.bd;
    }

    public InputStream getIs() {
        try {
            this.is = this.storage.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.is;
    }

    public int getAttachmentSize() {
        return this.attachmentSize;
    }

    public void setIs(InputStream is) {
        MemoryStorageProvider storageProvider = new MemoryStorageProvider();
        try {
            this.storage = storageProvider.store(is);
            this.attachmentSize = ((AbstractStorageProvider)storageProvider).getTotalBytesTransffered();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Attachment(BodyDescriptor bd, InputStream is) {
        this.bd = bd;
        this.attachmentSize = 0;
        this.setIs(is);
    }
}

