/*
 * Decompiled with CFR 0.152.
 */
package tech.blueglacier.util;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.message.MaximalBodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptor;
import tech.blueglacier.configuration.AppConfig;
import tech.blueglacier.disposition.ContentDispositionDecoder;
import tech.blueglacier.util.MimeWordDecoder;

public class Common {
    public static String getAttachmentNameFromDispositionParameters(BodyDescriptor bd) {
        String attachmentName = null;
        if (bd instanceof MaximalBodyDescriptor) {
            attachmentName = Common.getDecodedWord(((MaximalBodyDescriptor)bd).getContentDispositionFilename());
            if (StringUtils.isEmpty((String)attachmentName)) {
                attachmentName = Common.getDecodedWord((String)((MaximalBodyDescriptor)bd).getContentDispositionParameters().get("name"));
            }
            if (StringUtils.isEmpty((String)attachmentName)) {
                attachmentName = Common.getDecodedDispositionFileName(bd);
            }
        }
        return attachmentName;
    }

    private static String getDecodedDispositionFileName(BodyDescriptor bd) {
        String attachmentName = null;
        try {
            attachmentName = ContentDispositionDecoder.decodeDispositionFileName(((MaximalBodyDescriptor)bd).getContentDispositionParameters());
        }
        catch (MimeException e) {
            throw new RuntimeException(e);
        }
        return attachmentName;
    }

    private static String getDecodedWord(String filename) {
        filename = MimeWordDecoder.decodeEncodedWords(filename, DecodeMonitor.SILENT);
        return filename;
    }

    public static String getAttachmentNameFromContentTypeParmaeters(BodyDescriptor bd) {
        String attachmentName;
        block2: {
            block4: {
                String nameKey;
                Map contentTypeParameters;
                block3: {
                    attachmentName = null;
                    if (!(bd instanceof MaximalBodyDescriptor)) break block2;
                    contentTypeParameters = ((MaximalBodyDescriptor)bd).getContentTypeParameters();
                    nameKey = null;
                    nameKey = "name";
                    if (contentTypeParameters.containsKey("name")) break block3;
                    nameKey = "NAME";
                    if (contentTypeParameters.containsKey("NAME")) break block3;
                    nameKey = "Name";
                    if (!contentTypeParameters.containsKey("Name")) break block4;
                }
                attachmentName = (String)contentTypeParameters.get(nameKey);
            }
            attachmentName = Common.getDecodedWord(attachmentName);
        }
        return attachmentName;
    }

    public static String getAttachmentName(BodyDescriptor bd) {
        String attachmentName = Common.getAttachmentNameFromDispositionParameters(bd);
        if (attachmentName == null || attachmentName.isEmpty()) {
            attachmentName = Common.getAttachmentNameFromContentTypeParmaeters(bd);
        }
        return attachmentName;
    }

    public static String getFallbackCharset(String charSet) {
        Properties charSetMap = AppConfig.getInstance().getCharSetMap();
        charSet = charSetMap.getProperty(charSet.toLowerCase(), charSet);
        return charSet;
    }
}

