/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.employee.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import tech.deepdreams.employee.enums.ContractType;
import tech.deepdreams.employee.events.ContractUpdatedEvent;

public class ContractUpdatedEventDeserializer
extends JsonDeserializer<ContractUpdatedEvent> {
    public ContractUpdatedEvent deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        Long id = jsonNode.get("id").asLong();
        Long employeeId = jsonNode.get("employeeId").asLong();
        OffsetDateTime eventDate = OffsetDateTime.parse(jsonNode.get("eventDate").asText(), DateTimeFormatter.ISO_DATE_TIME);
        LocalDate hiringDate = LocalDate.parse(jsonNode.get("hiringDate").asText());
        ContractType contractType = ContractType.valueOf(jsonNode.get("contractType").asText());
        Integer contractDuration = jsonNode.get("contractDuration") == null ? null : Integer.valueOf(jsonNode.get("contractDuration").asInt());
        BigDecimal baseSalary = BigDecimal.valueOf(jsonNode.get("baseSalary").asDouble());
        Double weeklyWorkingHours = jsonNode.get("weeklyWorkingHours").asDouble();
        Integer annualLeaveDays = jsonNode.get("annualLeaveDays").asInt();
        Integer retirementAge = jsonNode.get("retirementAge").asInt();
        Long unitId = jsonNode.get("unitId") == null ? null : Long.valueOf(jsonNode.get("unitId").asLong());
        Long functionId = jsonNode.get("functionId") == null ? null : Long.valueOf(jsonNode.get("functionId").asLong());
        Long categoryId = jsonNode.get("categoryId") == null ? null : Long.valueOf(jsonNode.get("categoryId").asLong());
        Long echelonId = jsonNode.get("echelonId") == null ? null : Long.valueOf(jsonNode.get("echelonId").asLong());
        String username = jsonNode.get("username").asText();
        return ContractUpdatedEvent.builder().id(id).employeeId(employeeId).eventDate(eventDate).hiringDate(hiringDate).contractType(contractType).contractDuration(contractDuration).baseSalary(baseSalary).weeklyWorkingHours(weeklyWorkingHours).annualLeaveDays(annualLeaveDays).retirementAge(retirementAge).unitId(unitId).functionId(functionId).categoryId(categoryId).echelonId(echelonId).username(username).build();
    }
}

