/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.employee.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import tech.deepdreams.employee.events.EmployeeAccessGrantedEvent;

public class EmployeeAccessGrantedEventDeserializer
extends JsonDeserializer<EmployeeAccessGrantedEvent> {
    public EmployeeAccessGrantedEvent deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        Long id = jsonNode.get("id").asLong();
        Long employeeId = jsonNode.get("employeeId").asLong();
        OffsetDateTime eventDate = OffsetDateTime.parse(jsonNode.get("eventDate").asText(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        String accessCode = jsonNode.get("accessCode").asText();
        String username = jsonNode.get("username").asText();
        return EmployeeAccessGrantedEvent.builder().id(id).employeeId(employeeId).eventDate(eventDate).accessCode(accessCode).username(username).build();
    }
}

