/*
 * Decompiled with CFR 0.152.
 */
package tech.deepdreams.employee.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import tech.deepdreams.employee.events.ContractUpdatedEvent;

public class ContractUpdatedEventSerializer
extends JsonSerializer<ContractUpdatedEvent> {
    public void serialize(ContractUpdatedEvent event, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeNumberField("id", event.getId().longValue());
        jsonGenerator.writeNumberField("employeeId", event.getEmployeeId().longValue());
        jsonGenerator.writeStringField("eventDate", event.getEventDate().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        jsonGenerator.writeStringField("hiringDate", event.getHiringDate().format(DateTimeFormatter.ISO_DATE));
        jsonGenerator.writeStringField("contractType", event.getContractType().name());
        jsonGenerator.writeNumberField("contractDuration", event.getContractDuration().intValue());
        jsonGenerator.writeNumberField("baseSalary", event.getBaseSalary());
        jsonGenerator.writeNumberField("weeklyWorkingHours", event.getWeeklyWorkingHours().doubleValue());
        jsonGenerator.writeNumberField("annualLeaveDays", event.getAnnualLeaveDays().intValue());
        jsonGenerator.writeNumberField("retirementAge", event.getRetirementAge().intValue());
        jsonGenerator.writeNumberField("unitId", event.getUnitId().longValue());
        jsonGenerator.writeNumberField("functionId", event.getFunctionId().longValue());
        jsonGenerator.writeNumberField("categoryId", event.getCategoryId().longValue());
        jsonGenerator.writeNumberField("echelonId", event.getEchelonId().longValue());
        jsonGenerator.writeStringField("username", event.getUsername());
        jsonGenerator.writeEndObject();
    }
}

