/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.plugin.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.plugin.core.Plugin;
import org.springframework.plugin.core.SimplePluginRegistry;
import org.springframework.util.Assert;

public class OrderAwarePluginRegistry<T extends Plugin<S>, S>
extends SimplePluginRegistry<T, S> {
    static final Comparator<Object> DEFAULT_COMPARATOR = new AnnotationAwareOrderComparator();
    static final Comparator<Object> DEFAULT_REVERSE_COMPARATOR = DEFAULT_COMPARATOR.reversed();
    private final Comparator<? super T> comparator;

    protected OrderAwarePluginRegistry(List<? extends T> plugins, Comparator<? super T> comparator) {
        super(plugins);
        Assert.notNull(comparator, "Comparator must not be null!");
        this.comparator = comparator;
    }

    public static <S, T extends Plugin<S>> OrderAwarePluginRegistry<T, S> empty() {
        return OrderAwarePluginRegistry.create(Collections.emptyList());
    }

    public static <S, T extends Plugin<S>> OrderAwarePluginRegistry<T, S> of(Comparator<? super T> comparator) {
        Assert.notNull(comparator, "Comparator must not be null!");
        return OrderAwarePluginRegistry.of(Collections.emptyList(), comparator);
    }

    @SafeVarargs
    public static <S, T extends Plugin<S>> OrderAwarePluginRegistry<T, S> of(T ... plugins) {
        return OrderAwarePluginRegistry.of(Arrays.asList(plugins), DEFAULT_COMPARATOR);
    }

    public static <S, T extends Plugin<S>> OrderAwarePluginRegistry<T, S> of(List<? extends T> plugins) {
        return OrderAwarePluginRegistry.of(plugins, DEFAULT_COMPARATOR);
    }

    public static <S, T extends Plugin<S>> OrderAwarePluginRegistry<T, S> ofReverse(List<? extends T> plugins) {
        return OrderAwarePluginRegistry.of(plugins, DEFAULT_REVERSE_COMPARATOR);
    }

    public static <S, T extends Plugin<S>> OrderAwarePluginRegistry<T, S> of(List<? extends T> plugins, Comparator<? super T> comparator) {
        Assert.notNull(plugins, "Plugins must not be null!");
        Assert.notNull(comparator, "Comparator must not be null!");
        return new OrderAwarePluginRegistry<T, S>(plugins, comparator);
    }

    @Deprecated
    public static <S, T extends Plugin<S>> OrderAwarePluginRegistry<T, S> create() {
        return OrderAwarePluginRegistry.empty();
    }

    @Deprecated
    public static <S, T extends Plugin<S>> OrderAwarePluginRegistry<T, S> create(Comparator<? super T> comparator) {
        Assert.notNull(comparator, "Comparator must not be null!");
        return OrderAwarePluginRegistry.of(Collections.emptyList(), comparator);
    }

    @Deprecated
    public static <S, T extends Plugin<S>> OrderAwarePluginRegistry<T, S> create(List<? extends T> plugins) {
        return OrderAwarePluginRegistry.of(plugins, DEFAULT_COMPARATOR);
    }

    @Deprecated
    public static <S, T extends Plugin<S>> OrderAwarePluginRegistry<T, S> createReverse(List<? extends T> plugins) {
        return OrderAwarePluginRegistry.of(plugins, DEFAULT_REVERSE_COMPARATOR);
    }

    @Deprecated
    public static <S, T extends Plugin<S>> OrderAwarePluginRegistry<T, S> create(List<? extends T> plugins, Comparator<? super T> comparator) {
        return OrderAwarePluginRegistry.of(plugins, comparator);
    }

    @Override
    protected List<T> initialize(List<T> plugins) {
        List<T> result = super.initialize(plugins);
        Collections.sort(result, this.comparator);
        return result;
    }

    public OrderAwarePluginRegistry<T, S> reverse() {
        ArrayList copy = new ArrayList(this.getPlugins());
        return OrderAwarePluginRegistry.of(copy, this.comparator.reversed());
    }
}

