/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.plugin.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.plugin.core.Plugin;
import org.springframework.plugin.core.PluginRegistrySupport;
import org.springframework.util.Assert;

public class SimplePluginRegistry<T extends Plugin<S>, S>
extends PluginRegistrySupport<T, S> {
    protected SimplePluginRegistry(List<? extends T> plugins) {
        super(plugins);
    }

    public static <S, T extends Plugin<S>> SimplePluginRegistry<T, S> empty() {
        return SimplePluginRegistry.of(Collections.emptyList());
    }

    @SafeVarargs
    public static <S, T extends Plugin<S>> SimplePluginRegistry<T, S> of(T ... plugins) {
        return SimplePluginRegistry.of(Arrays.asList(plugins));
    }

    public static <S, T extends Plugin<S>> SimplePluginRegistry<T, S> of(List<? extends T> plugins) {
        return new SimplePluginRegistry<T, S>(plugins);
    }

    @Deprecated
    public static <S, T extends Plugin<S>> SimplePluginRegistry<T, S> create() {
        return SimplePluginRegistry.of(Collections.emptyList());
    }

    @Deprecated
    public static <S, T extends Plugin<S>> SimplePluginRegistry<T, S> create(List<? extends T> plugins) {
        return new SimplePluginRegistry<T, S>(plugins);
    }

    @Override
    public List<T> getPlugins() {
        return Collections.unmodifiableList(super.getPlugins());
    }

    @Override
    public Optional<T> getPluginFor(S delimiter) {
        Assert.notNull(delimiter, "Delimiter must not be null!");
        return super.getPlugins().stream().filter(it -> it.supports(delimiter)).findFirst();
    }

    @Override
    public T getRequiredPluginFor(S delimiter) {
        Assert.notNull(delimiter, "Delimiter must not be null!");
        return this.getRequiredPluginFor(delimiter, () -> String.format("No plugin found for delimiter %s! Registered plugins: %s.", delimiter, this.getPlugins()));
    }

    @Override
    public T getRequiredPluginFor(S delimiter, Supplier<String> message) throws IllegalArgumentException {
        Assert.notNull(delimiter, "Delimiter must not be null!");
        Assert.notNull(message, "Message must not be null!");
        return this.getPluginFor(delimiter, () -> new IllegalArgumentException((String)message.get()));
    }

    @Override
    public List<T> getPluginsFor(S delimiter) {
        Assert.notNull(delimiter, "Delimiter must not be null!");
        return super.getPlugins().stream().filter(it -> it.supports(delimiter)).collect(Collectors.toList());
    }

    @Override
    public <E extends Exception> T getPluginFor(S delimiter, Supplier<E> ex) throws E {
        Assert.notNull(delimiter, "Delimiter must not be null!");
        Assert.notNull(ex, "Exception supplier must not be null!");
        return (T)((Plugin)this.getPluginFor(delimiter).orElseThrow(ex));
    }

    @Override
    public <E extends Exception> List<T> getPluginsFor(S delimiter, Supplier<E> ex) throws E {
        Assert.notNull(delimiter, "Delimiter must not be null!");
        Assert.notNull(ex, "Exception supplier must not be null!");
        List<T> result = this.getPluginsFor(delimiter);
        if (result.isEmpty()) {
            throw (Exception)ex.get();
        }
        return result;
    }

    @Override
    public T getPluginOrDefaultFor(S delimiter, T plugin) {
        return (T)this.getPluginOrDefaultFor(delimiter, () -> plugin);
    }

    @Override
    public T getPluginOrDefaultFor(S delimiter, Supplier<T> defaultSupplier) {
        Assert.notNull(delimiter, "Delimiter must not be null!");
        Assert.notNull(defaultSupplier, "Default supplier must not be null!");
        return (T)((Plugin)this.getPluginFor(delimiter).orElseGet(defaultSupplier));
    }

    @Override
    public List<T> getPluginsFor(S delimiter, List<? extends T> plugins) {
        Assert.notNull(delimiter, "Delimiter must not be null!");
        Assert.notNull(plugins, "Plugins must not be null!");
        ArrayList<T> candidates = this.getPluginsFor(delimiter);
        return candidates.isEmpty() ? new ArrayList<T>(plugins) : candidates;
    }

    @Override
    public int countPlugins() {
        return super.getPlugins().size();
    }

    @Override
    public boolean contains(T plugin) {
        return super.getPlugins().contains(plugin);
    }

    @Override
    public boolean hasPluginFor(S delimiter) {
        return this.getPluginFor(delimiter).isPresent();
    }
}

