/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.builders.ContentSpecificationBuilder;
import springfox.documentation.builders.NoopValidator;
import springfox.documentation.builders.ParameterSpecificationContext;
import springfox.documentation.builders.ParameterSpecificationProvider;
import springfox.documentation.builders.RootParameterSpecificationProvider;
import springfox.documentation.builders.SimpleParameterSpecificationBuilder;
import springfox.documentation.builders.ValidationResult;
import springfox.documentation.builders.Validator;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.service.ContentSpecification;
import springfox.documentation.service.ParameterSpecification;
import springfox.documentation.service.ParameterStyle;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.SimpleParameterSpecification;
import springfox.documentation.service.VendorExtension;

public class RequestParameterBuilder {
    String name;
    ParameterType in;
    SimpleParameterSpecificationBuilder simpleParameterBuilder;
    ContentSpecificationBuilder contentSpecificationBuilder;
    private String description;
    private Boolean required = false;
    private Boolean deprecated;
    private Boolean hidden = false;
    private Example scalarExample;
    private int precedence;
    private int parameterIndex;
    private Validator<RequestParameterBuilder> validator = new NoopValidator<RequestParameterBuilder>();
    private ParameterSpecificationProvider parameterSpecificationProvider = new RootParameterSpecificationProvider();
    private final List<Example> examples = new ArrayList<Example>();
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();
    private final Set<MediaType> accepts = new HashSet<MediaType>();

    public RequestParameterBuilder name(String name) {
        this.name = BuilderDefaults.defaultIfAbsent(BuilderDefaults.emptyToNull(name), this.name);
        return this;
    }

    public RequestParameterBuilder in(ParameterType in) {
        this.in = BuilderDefaults.defaultIfAbsent(in, this.in);
        if (this.in == ParameterType.QUERY || this.in == ParameterType.COOKIE) {
            this.query(q -> q.style(ParameterStyle.FORM).allowReserved(in == ParameterType.QUERY));
        } else if (this.in == ParameterType.HEADER || this.in == ParameterType.PATH) {
            this.query(q -> q.style(ParameterStyle.SIMPLE).allowReserved(false));
        }
        return this;
    }

    public RequestParameterBuilder in(String in) {
        if (!StringUtils.isEmpty(in)) {
            this.in = ParameterType.from(in);
        }
        return this;
    }

    public RequestParameterBuilder description(String description) {
        this.description = BuilderDefaults.defaultIfAbsent(BuilderDefaults.emptyToNull(description), this.description);
        return this;
    }

    public RequestParameterBuilder required(Boolean required) {
        this.required = BuilderDefaults.defaultIfAbsent(Boolean.TRUE.equals(required) ? Boolean.valueOf(true) : null, this.required);
        return this;
    }

    public RequestParameterBuilder deprecated(Boolean deprecated) {
        this.deprecated = BuilderDefaults.defaultIfAbsent(deprecated, this.deprecated);
        return this;
    }

    private SimpleParameterSpecificationBuilder queryBuilder() {
        if (this.simpleParameterBuilder == null) {
            this.simpleParameterBuilder = new SimpleParameterSpecificationBuilder();
        }
        return this.simpleParameterBuilder;
    }

    public RequestParameterBuilder query(@NonNull Consumer<SimpleParameterSpecificationBuilder> parameter) {
        parameter.accept(this.queryBuilder());
        return this;
    }

    private ContentSpecificationBuilder contentBuilder() {
        if (this.contentSpecificationBuilder == null) {
            this.contentSpecificationBuilder = new ContentSpecificationBuilder();
        }
        return this.contentSpecificationBuilder;
    }

    public RequestParameterBuilder content(Consumer<ContentSpecificationBuilder> parameter) {
        parameter.accept(this.contentBuilder());
        return this;
    }

    public RequestParameterBuilder extensions(List<VendorExtension> extensions) {
        this.extensions.addAll(extensions);
        return this;
    }

    public RequestParameterBuilder hidden(Boolean hidden) {
        this.hidden = BuilderDefaults.defaultIfAbsent(hidden, this.hidden);
        return this;
    }

    public RequestParameterBuilder precedence(int precedence) {
        this.precedence = precedence;
        return this;
    }

    public RequestParameterBuilder example(Example scalarExample) {
        this.scalarExample = BuilderDefaults.defaultIfAbsent(scalarExample, this.scalarExample);
        return this;
    }

    public RequestParameterBuilder examples(Collection<Example> examples) {
        this.examples.addAll(examples);
        return this;
    }

    public RequestParameterBuilder parameterSpecificationProvider(ParameterSpecificationProvider specificationProvider) {
        this.parameterSpecificationProvider = specificationProvider;
        return this;
    }

    public RequestParameterBuilder accepts(Collection<MediaType> accepts) {
        this.accepts.addAll(BuilderDefaults.nullToEmptyList(accepts));
        return this;
    }

    public RequestParameterBuilder validator(Validator<RequestParameterBuilder> validator) {
        this.validator = validator;
        return this;
    }

    public RequestParameterBuilder parameterIndex(int parameterIndex) {
        this.parameterIndex = parameterIndex;
        return this;
    }

    public RequestParameter build() {
        List<ValidationResult> results = this.validator.validate(this);
        if (NoopValidator.logProblems(results).size() > 0) {
            return null;
        }
        ParameterSpecification parameter = this.parameterSpecificationProvider.create(new ParameterSpecificationContext(this.name, this.in, this.accepts, this.simpleParameterBuilder != null ? this.simpleParameterBuilder.build() : null, this.contentSpecificationBuilder != null ? this.contentSpecificationBuilder.build() : null, new SimpleParameterSpecificationBuilder(), new ContentSpecificationBuilder()));
        return new RequestParameter(this.name, this.in, this.description, this.in == ParameterType.PATH ? true : this.required, this.deprecated, this.hidden, parameter, this.scalarExample, this.examples, this.precedence, this.extensions, this.parameterIndex);
    }

    public RequestParameterBuilder copyOf(RequestParameter source) {
        source.getParameterSpecification().getQuery().ifPresent(simple -> this.query(q -> q.copyOf((SimpleParameterSpecification)simple)));
        source.getParameterSpecification().getContent().ifPresent(content -> this.content(c -> c.copyOf((ContentSpecification)content)));
        return this.in(source.getIn()).required(source.getRequired()).hidden(source.getHidden()).deprecated(source.getDeprecated()).extensions(source.getExtensions()).name(source.getName()).description(source.getDescription()).precedence(source.getPrecedence()).example(source.getScalarExample()).examples(source.getExamples()).parameterIndex(source.getParameterIndex());
    }

    public void contentModel(ModelSpecification model) {
        if (this.accepts.isEmpty()) {
            this.accepts.add(MediaType.APPLICATION_JSON);
        }
        this.accepts.forEach(each -> this.content(c -> c.requestBody(true).representation((MediaType)each).apply(r -> r.model(m -> m.copyOf(model)))));
    }
}

