/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;

public class Enums {
    private Enums() {
        throw new UnsupportedOperationException();
    }

    public static AllowableValues allowableValues(Class<?> type) {
        if (type.isEnum()) {
            List<String> enumValues = Enums.getEnumValues(type);
            return new AllowableListValues(enumValues, "LIST");
        }
        return null;
    }

    static List<String> getEnumValues(Class<?> subject) {
        return Enums.transformUnique(subject.getEnumConstants(), input -> {
            Optional<String> jsonValue = Enums.findJsonValueAnnotatedMethod(input).map(Enums.evaluateJsonValue(input));
            if (jsonValue.isPresent() && !StringUtils.isEmpty(jsonValue.get())) {
                return jsonValue.get();
            }
            return ((Enum)input).name();
        });
    }

    private static Function<Method, String> evaluateJsonValue(Object enumConstant) {
        return input -> {
            try {
                return input.invoke(enumConstant, new Object[0]).toString();
            }
            catch (Exception exception) {
                return "";
            }
        };
    }

    private static <E> List<String> transformUnique(E[] values, Function<E, String> mapper) {
        return Stream.of(values).map(mapper).distinct().collect(Collectors.toList());
    }

    private static Optional<Method> findJsonValueAnnotatedMethod(Object enumConstant) {
        for (Method each : enumConstant.getClass().getMethods()) {
            JsonValue jsonValue = AnnotationUtils.findAnnotation(each, JsonValue.class);
            if (jsonValue == null || !jsonValue.value()) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public static AllowableValues emptyListValuesToNull(AllowableListValues values) {
        if (!values.getValues().isEmpty()) {
            return values;
        }
        return null;
    }
}

