/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Annotations;
import springfox.documentation.schema.JacksonXmlPresentInClassPathCondition;
import springfox.documentation.schema.Xml;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Conditional(value={JacksonXmlPresentInClassPathCondition.class})
public class JacksonXmlPropertyPlugin
implements ModelPropertyBuilderPlugin {
    @Override
    public void apply(ModelPropertyContext context) {
        Optional<JacksonXmlProperty> propertyAnnotation = JacksonXmlPropertyPlugin.findAnnotation(context, JacksonXmlProperty.class);
        if (propertyAnnotation.isPresent()) {
            if (propertyAnnotation.get().isAttribute()) {
                context.getBuilder().xml(new Xml().attribute(true).namespace(this.defaultToNull(propertyAnnotation.get().namespace())).name(this.propertyName(propertyAnnotation)).wrapped(false));
                context.getSpecificationBuilder().xml(new Xml().attribute(true).namespace(this.defaultToNull(propertyAnnotation.get().namespace())).name(this.propertyName(propertyAnnotation)).wrapped(false));
            } else {
                Optional<JacksonXmlElementWrapper> wrapper = JacksonXmlPropertyPlugin.findAnnotation(context, JacksonXmlElementWrapper.class);
                context.getBuilder().xml(new Xml().attribute(false).namespace(this.defaultToNull(propertyAnnotation.get().namespace())).name(this.wrapperName(wrapper, propertyAnnotation)).wrapped(wrapper.isPresent()));
                context.getSpecificationBuilder().xml(new Xml().attribute(false).namespace(this.defaultToNull(propertyAnnotation.get().namespace())).name(this.wrapperName(wrapper, propertyAnnotation)).wrapped(wrapper.isPresent()));
            }
        }
    }

    private static <T extends Annotation> Optional<T> findAnnotation(ModelPropertyContext context, Class<T> annotationClass) {
        Optional<Annotation> annotation = Optional.empty();
        if (context.getAnnotatedElement().isPresent()) {
            annotation = annotation.map(Optional::of).orElse(JacksonXmlPropertyPlugin.findAnnotation(context.getAnnotatedElement().get(), annotationClass));
        }
        if (context.getBeanPropertyDefinition().isPresent()) {
            annotation = annotation.map(Optional::of).orElse(Annotations.findPropertyAnnotation(context.getBeanPropertyDefinition().get(), annotationClass));
        }
        return annotation;
    }

    public static <T extends Annotation> Optional<T> findAnnotation(AnnotatedElement annotated, Class<T> annotation) {
        return Optional.ofNullable(AnnotationUtils.getAnnotation(annotated, annotation));
    }

    private String wrapperName(Optional<JacksonXmlElementWrapper> wrapper, Optional<JacksonXmlProperty> property) {
        if (wrapper.isPresent() && wrapper.get().useWrapping()) {
            return Optional.ofNullable(this.defaultToNull(Optional.ofNullable(wrapper.get().localName()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null))).orElse(Optional.ofNullable(this.propertyName(property)).orElse(null));
        }
        return this.propertyName(property);
    }

    private String propertyName(Optional<JacksonXmlProperty> property) {
        return property.map(jacksonXmlProperty -> this.defaultToNull(Optional.ofNullable(jacksonXmlProperty.localName()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null))).orElse(null);
    }

    private String defaultToNull(String value) {
        return "##default".equalsIgnoreCase(value) ? null : value;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

