/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.core.Ordered;
import org.springframework.http.HttpMethod;
import springfox.documentation.common.ExternalDocumentation;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.ContentSpecification;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.RequestBody;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.Response;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.VendorExtension;

public class Operation
implements Ordered {
    private final HttpMethod method;
    private final String summary;
    private final String notes;
    private final ExternalDocumentation externalDocumentation;
    private final String uniqueId;
    private final Set<String> tags;
    private final Map<String, List<AuthorizationScope>> securityReferences;
    private final Set<RequestParameter> requestParameters;
    private final RequestBody body;
    private final Set<Response> responses;
    private final String deprecated;
    private final List<VendorExtension> vendorExtensions;
    private final int position;
    private final List<Parameter> parameters;
    private final Set<ResponseMessage> responseMessages;
    private final ModelReference responseModel;
    private final Set<String> produces;
    private final Set<String> consumes;
    private final Set<String> protocol;
    private final boolean isHidden;

    public Operation(HttpMethod method, String summary, String notes, ExternalDocumentation externalDocumentation, ModelReference responseModel, String uniqueId, int position, Set<String> tags, Set<String> produces, Set<String> consumes, Set<String> protocol, List<SecurityReference> securityReferences, List<Parameter> parameters, Set<ResponseMessage> responseMessages, String deprecated, boolean isHidden, Collection<VendorExtension> vendorExtensions, Set<RequestParameter> requestParameters, RequestBody body, Set<Response> responses) {
        this.method = method;
        this.summary = summary;
        this.notes = notes;
        this.externalDocumentation = externalDocumentation;
        this.responseModel = responseModel;
        this.uniqueId = uniqueId;
        this.position = position;
        this.tags = tags;
        this.produces = produces;
        this.consumes = consumes;
        this.protocol = protocol;
        this.requestParameters = requestParameters;
        this.responses = responses;
        this.isHidden = isHidden;
        this.securityReferences = this.toAuthorizationsMap(securityReferences);
        this.parameters = parameters.stream().sorted(this.byOrder().thenComparing(this.byParameterName())).collect(Collectors.toList());
        this.responseMessages = responseMessages;
        this.deprecated = deprecated;
        this.body = body;
        this.vendorExtensions = new ArrayList<VendorExtension>(vendorExtensions);
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    @Deprecated
    public ModelReference getResponseModel() {
        return this.responseModel;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    private Map<String, List<AuthorizationScope>> toAuthorizationsMap(List<SecurityReference> securityReferences) {
        return securityReferences.stream().collect(Collectors.toMap(SecurityReference::getReference, value -> new ArrayList<AuthorizationScope>(value.getScopes())));
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public int getPosition() {
        return this.position;
    }

    public Set<String> getProduces() {
        return this.produces;
    }

    public Set<String> getConsumes() {
        return this.consumes;
    }

    public Set<String> getProtocol() {
        return this.protocol;
    }

    public Map<String, List<AuthorizationScope>> getSecurityReferences() {
        return this.securityReferences;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Deprecated
    public Set<ResponseMessage> getResponseMessages() {
        return this.responseMessages;
    }

    public SortedSet<Response> getResponses() {
        return this.responses.stream().collect(Collectors.toCollection(() -> new TreeSet<Response>(Comparator.comparing(Response::getCode))));
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public List<VendorExtension> getVendorExtensions() {
        return this.vendorExtensions;
    }

    private Comparator<Parameter> byOrder() {
        return Comparator.comparingInt(Parameter::getOrder);
    }

    private Comparator<Parameter> byParameterName() {
        return Comparator.comparing(Parameter::getName);
    }

    @Override
    public int getOrder() {
        return this.position;
    }

    public Set<RequestParameter> getRequestParameters() {
        return this.requestParameters;
    }

    public SortedSet<RequestParameter> getQueryParameters() {
        return this.requestParameters.stream().filter(r -> !r.getParameterSpecification().getContent().isPresent()).collect(Collectors.toCollection(() -> new TreeSet<RequestParameter>(Comparator.comparing(RequestParameter::getParameterIndex).thenComparing(RequestParameter::getName))));
    }

    public RequestBody getBody() {
        return this.requestParameters.stream().filter(r -> r.getParameterSpecification().getContent().isPresent()).findFirst().map(this::toBody).orElse(this.body);
    }

    private RequestBody toBody(RequestParameter parameter) {
        return new RequestBody(parameter.getDescription(), parameter.getParameterSpecification().getContent().map(ContentSpecification::getRepresentations).orElse(new HashSet()), parameter.getRequired(), parameter.getExtensions());
    }

    public ExternalDocumentation getExternalDocumentation() {
        return this.externalDocumentation;
    }

    public String toString() {
        return new StringJoiner(", ", Operation.class.getSimpleName() + "[", "]").add("method=" + this.method).add("summary='" + this.summary + "'").add("notes='" + this.notes + "'").add("externalDocumentation=" + this.externalDocumentation).add("uniqueId='" + this.uniqueId + "'").add("position=" + this.position).add("tags=" + this.tags).add("responseModel=" + this.responseModel).add("produces=" + this.produces).add("consumes=" + this.consumes).add("protocol=" + this.protocol).add("isHidden=" + this.isHidden).add("securityReferences=" + this.securityReferences).add("parameters=" + this.parameters).add("responseMessages=" + this.responseMessages).add("requestParameters=" + this.requestParameters).add("body=" + this.body).add("responses=" + this.responses).add("deprecated='" + this.deprecated + "'").add("vendorExtensions=" + this.vendorExtensions).toString();
    }
}

