/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.json.Jackson2CodecSupport;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.support.DefaultServerCodecConfigurer;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;

public class WebFluxObjectMapperConfigurer
implements BeanPostProcessor,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof Jackson2CodecSupport) {
            Jackson2CodecSupport encoder = (Jackson2CodecSupport)bean2;
            this.fireObjectMapperConfiguredEvent(encoder.getObjectMapper());
        }
        if (bean2 instanceof DefaultServerCodecConfigurer) {
            List readers = ((DefaultServerCodecConfigurer)bean2).getReaders();
            for (HttpMessageReader reader : readers) {
                Decoder decoder;
                if (!(reader instanceof DecoderHttpMessageReader) || !((decoder = ((DecoderHttpMessageReader)reader).getDecoder()) instanceof Jackson2JsonDecoder)) continue;
                this.fireObjectMapperConfiguredEvent(((Jackson2JsonDecoder)decoder).getObjectMapper());
                return bean2;
            }
            List writers = ((DefaultServerCodecConfigurer)bean2).getWriters();
            for (HttpMessageWriter writer : writers) {
                Encoder encoder;
                if (!(writer instanceof EncoderHttpMessageWriter) || !((encoder = ((EncoderHttpMessageWriter)writer).getEncoder()) instanceof Jackson2JsonEncoder)) continue;
                this.fireObjectMapperConfiguredEvent(((Jackson2JsonEncoder)encoder).getObjectMapper());
                return bean2;
            }
        }
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        return bean2;
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    private void fireObjectMapperConfiguredEvent(ObjectMapper objectMapper) {
        this.applicationEventPublisher.publishEvent(new ObjectMapperConfigured(this, objectMapper));
    }
}

