/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.web.ControllerNamingUtils;
import springfox.documentation.spring.web.WebMvcNameValueExpressionWrapper;
import springfox.documentation.spring.web.WebMvcPatternsRequestConditionWrapper;
import springfox.documentation.spring.web.WebMvcRequestMappingInfoWrapper;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;
import springfox.documentation.spring.wrapper.NameValueExpression;
import springfox.documentation.spring.wrapper.PatternsRequestCondition;
import springfox.documentation.spring.wrapper.RequestMappingInfo;

public class WebMvcRequestHandler
implements RequestHandler {
    private final String contextPath;
    private final HandlerMethodResolver methodResolver;
    private final org.springframework.web.servlet.mvc.method.RequestMappingInfo requestMapping;
    private final HandlerMethod handlerMethod;

    public WebMvcRequestHandler(String contextPath, HandlerMethodResolver methodResolver, org.springframework.web.servlet.mvc.method.RequestMappingInfo requestMapping, HandlerMethod handlerMethod) {
        this.contextPath = contextPath;
        this.methodResolver = methodResolver;
        this.requestMapping = requestMapping;
        this.handlerMethod = handlerMethod;
    }

    @Override
    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    @Override
    public RequestHandler combine(RequestHandler other) {
        return this;
    }

    @Override
    public Class<?> declaringClass() {
        return this.handlerMethod.getBeanType();
    }

    @Override
    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return null != AnnotationUtils.findAnnotation(this.handlerMethod.getMethod(), annotation);
    }

    @Override
    public PatternsRequestCondition getPatternsCondition() {
        return new WebMvcPatternsRequestConditionWrapper(this.contextPath, this.requestMapping.getPatternsCondition());
    }

    @Override
    public String groupName() {
        return ControllerNamingUtils.controllerNameAsGroup(this.handlerMethod);
    }

    @Override
    public String getName() {
        return this.handlerMethod.getMethod().getName();
    }

    @Override
    public Set<RequestMethod> supportedMethods() {
        return this.requestMapping.getMethodsCondition().getMethods();
    }

    @Override
    public Set<MediaType> produces() {
        return this.requestMapping.getProducesCondition().getProducibleMediaTypes();
    }

    @Override
    public Set<MediaType> consumes() {
        return this.requestMapping.getConsumesCondition().getConsumableMediaTypes();
    }

    @Override
    public Set<NameValueExpression<String>> headers() {
        return WebMvcNameValueExpressionWrapper.from(this.requestMapping.getHeadersCondition().getExpressions());
    }

    @Override
    public Set<NameValueExpression<String>> params() {
        return WebMvcNameValueExpressionWrapper.from(this.requestMapping.getParamsCondition().getExpressions());
    }

    @Override
    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation(this.handlerMethod.getMethod(), annotation));
    }

    @Override
    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.requestMapping.getPatternsCondition().getPatterns(), this.requestMapping.getMethodsCondition().getMethods(), this.requestMapping.getConsumesCondition().getConsumableMediaTypes(), this.requestMapping.getProducesCondition().getProducibleMediaTypes());
    }

    @Override
    public RequestMappingInfo<?> getRequestMapping() {
        return new WebMvcRequestMappingInfoWrapper(this.requestMapping);
    }

    @Override
    public List<ResolvedMethodParameter> getParameters() {
        return this.methodResolver.methodParameters(this.handlerMethod);
    }

    @Override
    public ResolvedType getReturnType() {
        return this.methodResolver.methodReturnType(this.handlerMethod);
    }

    @Override
    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation(this.handlerMethod.getBeanType(), annotation));
    }

    public String toString() {
        return new StringJoiner(", ", WebMvcRequestHandler.class.getSimpleName() + "{", "}").add("requestMapping=" + this.requestMapping).add("handlerMethod=" + this.handlerMethod).add("key=" + this.key()).toString();
    }
}

