/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.ModelSpecificationFactory;
import springfox.documentation.service.Response;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.ViewProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ResponseContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;

@Component
@Order(value=-2147483648)
public class ResponseMessagesReader
implements OperationBuilderPlugin {
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final TypeNameExtractor typeNameExtractor;
    private final SchemaPluginsManager pluginsManager;
    private final ModelSpecificationFactory modelSpecifications;
    private final DocumentationPluginsManager documentationPlugins;

    @Autowired
    public ResponseMessagesReader(EnumTypeDeterminer enumTypeDeterminer, TypeNameExtractor typeNameExtractor, SchemaPluginsManager pluginsManager, ModelSpecificationFactory modelSpecifications, DocumentationPluginsManager documentationPlugins) {
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.typeNameExtractor = typeNameExtractor;
        this.pluginsManager = pluginsManager;
        this.modelSpecifications = modelSpecifications;
        this.documentationPlugins = documentationPlugins;
    }

    @Override
    public void apply(OperationContext context) {
        List<ResponseMessage> responseMessages = context.getGlobalResponseMessages(context.httpMethod().toString());
        context.operationBuilder().responseMessages(new HashSet<ResponseMessage>(responseMessages));
        context.operationBuilder().responses(new HashSet<Response>(context.globalResponsesFor(context.httpMethod())));
        this.applyReturnTypeOverride(context);
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private void applyReturnTypeOverride(OperationContext context) {
        ResolvedType returnType2 = context.alternateFor(context.getReturnType());
        int httpStatusCode = ResponseMessagesReader.httpStatusCode(context);
        String message = ResponseMessagesReader.message(context);
        ModelReference modelRef = null;
        ViewProviderPlugin viewProvider = this.pluginsManager.viewProvider(context.getDocumentationContext().getDocumentationType());
        ResponseContext responseContext = new ResponseContext(context.getDocumentationContext(), context);
        if (!ResolvedTypes.isVoid(returnType2)) {
            ModelContext modelContext = context.operationModelsBuilder().addReturn(returnType2, viewProvider.viewFor(context));
            HashMap<String, String> knownNames = new HashMap<String, String>();
            ((Set)Optional.ofNullable(context.getKnownModels().get(modelContext.getParameterId())).orElse(new HashSet())).forEach(model -> knownNames.put(model.getId(), model.getName()));
            modelRef = ResolvedTypes.modelRefFactory(modelContext, this.enumTypeDeterminer, this.typeNameExtractor, knownNames).apply(returnType2);
            HashSet<MediaType> produces = new HashSet<MediaType>(context.produces());
            if (produces.isEmpty()) {
                produces.add(MediaType.ALL);
            }
            produces.forEach(mediaType -> responseContext.responseBuilder().representation((MediaType)mediaType).apply(r -> r.model(m -> m.copyOf(this.modelSpecifications.create(modelContext, returnType2)))));
        }
        ResponseMessage built = new ResponseMessageBuilder().code(httpStatusCode).message(message).responseModel(modelRef).build();
        responseContext.responseBuilder().description(message).code(String.valueOf(httpStatusCode));
        context.operationBuilder().responseMessages(Collections.singleton(built));
        context.operationBuilder().responses(Collections.singleton(this.documentationPlugins.response(responseContext)));
    }

    public static int httpStatusCode(OperationContext context) {
        Optional<ResponseStatus> responseStatus = context.findAnnotation(ResponseStatus.class);
        int httpStatusCode = HttpStatus.OK.value();
        if (responseStatus.isPresent()) {
            httpStatusCode = responseStatus.get().value().value();
        }
        return httpStatusCode;
    }

    public static String message(OperationContext context) {
        Optional<ResponseStatus> responseStatus = context.findAnnotation(ResponseStatus.class);
        String reasonPhrase = HttpStatus.OK.getReasonPhrase();
        if (responseStatus.isPresent() && (reasonPhrase = responseStatus.get().reason()).isEmpty()) {
            reasonPhrase = responseStatus.get().value().getReasonPhrase();
        }
        return reasonPhrase;
    }
}

