/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.common;

import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import springfox.documentation.common.SpringVersion;
import springfox.documentation.common.SpringVersionCapability;
import springfox.documentation.service.PathAdjuster;

public class XForwardPrefixPathAdjuster
implements PathAdjuster {
    static final String X_FORWARDED_PREFIX = "X-Forwarded-Prefix";
    private final HttpServletRequest request;
    private final SpringVersion springVersion;

    public XForwardPrefixPathAdjuster(HttpServletRequest request) {
        this(request, new SpringVersion());
    }

    XForwardPrefixPathAdjuster(HttpServletRequest request, SpringVersion springVersion) {
        this.request = request;
        this.springVersion = springVersion;
    }

    @Override
    public String adjustedPath(String path) {
        String prefix = this.request.getHeader(X_FORWARDED_PREFIX);
        if (prefix != null) {
            String string = prefix = StringUtils.isEmpty(prefix) ? "/" : prefix;
            if (!SpringVersionCapability.supportsXForwardPrefixHeader(this.springVersion.getVersion())) {
                return prefix + path;
            }
            return prefix;
        }
        return path;
    }
}

