/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ExampleBuilder;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.property.ModelSpecificationFactory;
import springfox.documentation.service.Header;
import springfox.documentation.service.Response;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ResponseContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.operation.ResponseHeaders;

@Component
@Order(value=-2147481648)
public class OpenApiResponseReader
implements OperationBuilderPlugin {
    private final TypeResolver typeResolver;
    private final ModelSpecificationFactory modelSpecifications;
    private final DocumentationPluginsManager documentationPlugins;

    @Autowired
    public OpenApiResponseReader(TypeResolver typeResolver, ModelSpecificationFactory modelSpecifications, DocumentationPluginsManager documentationPlugins) {
        this.typeResolver = typeResolver;
        this.modelSpecifications = modelSpecifications;
        this.documentationPlugins = documentationPlugins;
    }

    @Override
    public void apply(OperationContext context) {
        context.operationBuilder().responses(this.read(context));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    protected Set<Response> read(OperationContext context) {
        ResolvedType defaultResponse = context.getReturnType();
        Optional<Operation> operationAnnotation = context.findAnnotation(Operation.class);
        Optional<ApiResponses> responsesAnnotation = context.findAnnotation(ApiResponses.class);
        Optional<ApiResponse> responseAnnotation = context.findAnnotation(ApiResponse.class);
        List allApiResponses = Stream.concat(((Collection)operationAnnotation.map(Annotations.fromOperationAnnotation()).orElse(new ArrayList())).stream(), ((Collection)responsesAnnotation.map(Annotations.fromApiResponsesAnnotation()).orElse(new ArrayList())).stream()).collect(Collectors.toList());
        responseAnnotation.ifPresent(allApiResponses::add);
        HashSet<Response> responses = new HashSet<Response>();
        for (ApiResponse apiResponse : allApiResponses) {
            HashMap<String, Header> headers = new HashMap<String, Header>();
            ArrayList<Example> examples = new ArrayList<Example>();
            ResponseContext responseContext = new ResponseContext(context.getDocumentationContext(), context);
            for (Content each : apiResponse.content()) {
                Optional<ResolvedType> type = this.resolvedType(each.schema());
                if (OpenApiResponseReader.isSuccessful(apiResponse.responseCode())) {
                    type = type.map(Optional::of).orElse(Optional.of(defaultResponse));
                }
                if (!type.isPresent()) continue;
                ModelContext modelContext = context.operationModelsBuilder().addReturn(this.typeResolver.resolve(each.schema().implementation(), new Type[0]), Optional.empty());
                for (ExampleObject eachExample : each.examples()) {
                    if (StringUtils.isEmpty(eachExample.value())) continue;
                    examples.add(new ExampleBuilder().mediaType(each.mediaType()).description(eachExample.description()).summary(eachExample.summary()).id(eachExample.name()).value(eachExample.value()).build());
                }
                headers.putAll(ResponseHeaders.headers(apiResponse.headers()));
                type.ifPresent(t -> responseContext.responseBuilder().representation(each.mediaType().isEmpty() ? MediaType.ALL : MediaType.valueOf((String)each.mediaType())).apply(r -> r.model(m -> m.copyOf(this.modelSpecifications.create(modelContext, (ResolvedType)t)))));
            }
            responseContext.responseBuilder().examples(examples).description(apiResponse.description()).headers(headers.values()).code(apiResponse.responseCode());
            responses.add(this.documentationPlugins.response(responseContext));
        }
        return responses;
    }

    static boolean isSuccessful(String code) {
        try {
            return HttpStatus.Series.SUCCESSFUL.equals((Object)HttpStatus.Series.valueOf((String)code));
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private Optional<ResolvedType> resolvedType(Schema apiResponse) {
        return Optional.ofNullable(Annotations.resolvedTypeFromSchema(this.typeResolver, null).apply(apiResponse));
    }
}

