/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.AuthorizationScopeBuilder;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class OperationAuthReader
implements OperationBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(OperationAuthReader.class);

    @Override
    public void apply(OperationContext context) {
        List<SecurityContext> securityContexts = context.securityContext();
        HashMap<String, SecurityReference> securityReferences = new HashMap<String, SecurityReference>();
        for (SecurityContext each : securityContexts) {
            securityReferences.putAll(each.securityForOperation(context).stream().collect(Collectors.toMap(this.byReferenceName(), Function.identity())));
        }
        this.maybeProcessApiOperation(context, securityReferences);
        LOG.debug("Authorization count {} for method {}", (Object)securityReferences.size(), (Object)context.getName());
        context.operationBuilder().authorizations(securityReferences.values());
    }

    private void maybeProcessApiOperation(OperationContext context, Map<String, SecurityReference> securityReferences) {
        Optional<ApiOperation> apiOperationAnnotation = context.findAnnotation(ApiOperation.class);
        apiOperationAnnotation.ifPresent(apiOp -> {
            ArrayList<SecurityReference> securityReferenceOverrides = new ArrayList<SecurityReference>();
            for (Authorization authorization : this.authorizationReferences((ApiOperation)apiOperationAnnotation.get())) {
                String value = authorization.value();
                io.swagger.annotations.AuthorizationScope[] scopes = authorization.scopes();
                ArrayList<AuthorizationScope> authorizationScopeList = new ArrayList<AuthorizationScope>();
                for (io.swagger.annotations.AuthorizationScope authorizationScope : scopes) {
                    String description = authorizationScope.description();
                    String scope = authorizationScope.scope();
                    if (StringUtils.isEmpty(scope)) continue;
                    authorizationScopeList.add(new AuthorizationScopeBuilder().scope(scope).description(description).build());
                }
                AuthorizationScope[] authorizationScopes = authorizationScopeList.toArray(new AuthorizationScope[0]);
                SecurityReference securityReference = SecurityReference.builder().reference(value).scopes(authorizationScopes).build();
                securityReferenceOverrides.add(securityReference);
            }
            securityReferences.putAll(securityReferenceOverrides.stream().collect(Collectors.toMap(this.byReferenceName(), Function.identity())));
        });
    }

    private Function<SecurityReference, String> byReferenceName() {
        return SecurityReference::getReference;
    }

    private Iterable<Authorization> authorizationReferences(ApiOperation apiOperationAnnotation) {
        return Stream.of(apiOperationAnnotation.authorizations()).filter(input -> !StringUtils.isEmpty(input.value())).collect(Collectors.toList());
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

